/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.security.user;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.security.user.SMSubject;

public class SMTeam
extends SMSubject {
    private String teamName;
    private String description;
    private Set<String> permissions = new LinkedHashSet<String>();

    public SMTeam(String teamId) {
        this(teamId, null, null);
    }

    public SMTeam(String teamId, String name, String description) {
        super(teamId, null);
        this.teamName = name;
        this.description = description;
    }

    @NotNull
    public String getName() {
        return Objects.requireNonNullElse(this.teamName, this.subjectId);
    }

    @Property(viewable=true, order=1)
    public String getTeamId() {
        return this.subjectId;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getTeamName() {
        return Objects.requireNonNullElse(this.teamName, this.subjectId);
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    @Property(viewable=true, order=3)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(String permission) {
        this.permissions.add(permission);
    }

    public String toString() {
        return this.getTeamId();
    }
}

