/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import com.influxdb.utils.Arguments;
import javax.annotation.Nonnull;

public final class QuantileFlux
extends AbstractParametrizedFlux {
    public QuantileFlux(@Nonnull Flux source) {
        super(source);
    }

    @Override
    @Nonnull
    protected String operatorName() {
        return "quantile";
    }

    @Nonnull
    public QuantileFlux withColumn(@Nonnull String column) {
        Arguments.checkNonEmpty((String)column, (String)"column");
        this.withPropertyValueEscaped("column", column);
        return this;
    }

    @Nonnull
    public QuantileFlux withQuantile(@Nonnull Float quantile) {
        Arguments.checkNotNull((Object)quantile, (String)"quantile");
        this.withPropertyValue("q", quantile);
        return this;
    }

    @Nonnull
    public QuantileFlux withCompression(@Nonnull Float compression) {
        Arguments.checkNotNull((Object)compression, (String)"compression");
        this.withPropertyValue("compression", compression);
        return this;
    }

    @Nonnull
    public QuantileFlux withMethod(@Nonnull String method) {
        Arguments.checkNotNull((Object)method, (String)"method");
        this.withPropertyValueEscaped("method", method);
        return this;
    }

    @Nonnull
    public QuantileFlux withMethod(@Nonnull MethodType method) {
        Arguments.checkNotNull((Object)((Object)method), (String)"method");
        this.withPropertyValueEscaped("method", method.toString().toLowerCase());
        return this;
    }

    public static enum MethodType {
        ESTIMATE_TDIGEST,
        EXACT_MEAN,
        EXACT_SELECTOR;

    }
}

