/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.VariableAssignment;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import com.influxdb.utils.Arguments;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class JoinFlux
extends AbstractParametrizedFlux {
    private final Map<String, Flux> tables = new LinkedHashMap<String, Flux>();
    private String assignToVariable;

    public JoinFlux() {
        this.withPropertyValue("tables", () -> this.tables.entrySet().stream().map((? super T e) -> {
            String var = e.getValue() instanceof VariableAssignment ? ((VariableAssignment)e.getValue()).getVariableName() : (String)e.getKey();
            return (String)e.getKey() + ":" + var;
        }).collect(Collectors.joining(", ", "{", "}")));
    }

    @Override
    @Nonnull
    protected String operatorName() {
        return "join";
    }

    @Override
    protected void beforeAppendOperatorName(@Nonnull StringBuilder operator, @Nonnull Map<String, Object> parameters) {
        this.tables.forEach((key, flux) -> {
            if (flux instanceof JoinFlux) {
                operator.append(flux.toString(parameters)).append("\n");
            } else if (!(flux instanceof VariableAssignment)) {
                operator.append((String)key).append(" = ").append(flux.toString(parameters)).append("\n");
            }
        });
        if (this.assignToVariable != null) {
            operator.append(this.assignToVariable).append(" = ");
        }
    }

    @Nonnull
    public JoinFlux withTable(@Nonnull String name, @Nonnull Flux table) {
        Arguments.checkNonEmpty((String)name, (String)"FluxTable name");
        Arguments.checkNotNull((Object)table, (String)"Flux script to map table");
        this.tables.put(name, table);
        if (table instanceof JoinFlux) {
            ((JoinFlux)table).assignToVariable = name;
        }
        return this;
    }

    @Nonnull
    public JoinFlux withOn(@Nonnull String tag) {
        Arguments.checkNonEmpty((String)tag, (String)"Tag name");
        return this.withOn(new String[]{tag});
    }

    @Nonnull
    public JoinFlux withOn(@Nonnull String[] tags) {
        Arguments.checkNotNull((Object)tags, (String)"Tags are required");
        this.withPropertyValue("on", tags);
        return this;
    }

    @Nonnull
    public JoinFlux withOn(@Nonnull Collection<String> tags) {
        Arguments.checkNotNull(tags, (String)"Tags are required");
        this.withPropertyValue("on", tags);
        return this;
    }

    @Nonnull
    public JoinFlux withMethod(@Nonnull String method) {
        Arguments.checkNonEmpty((String)method, (String)"Method");
        this.withPropertyValueEscaped("method", method);
        return this;
    }

    @Nonnull
    public JoinFlux withMethod(@Nonnull MethodType method) {
        Arguments.checkNotNull((Object)((Object)method), (String)"Method");
        this.withPropertyValueEscaped("method", method.toString().toLowerCase());
        return this;
    }

    public static enum MethodType {
        INNER,
        CROSS,
        LEFT,
        RIGHT,
        OUTER;

    }
}

