/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import com.influxdb.utils.Arguments;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;

public final class FromFlux
extends AbstractParametrizedFlux {
    private final FluxOptions options = new FluxOptions();

    @Override
    @Nonnull
    protected String operatorName() {
        return "from";
    }

    @Nonnull
    public FromFlux withBucket(@Nonnull String bucket) {
        Arguments.checkNonEmpty((String)bucket, (String)"Bucket name");
        this.withPropertyValueEscaped("bucket", bucket);
        return this;
    }

    @Nonnull
    public FromFlux withHosts(@Nonnull Collection<String> hosts) {
        Arguments.checkNotNull(hosts, (String)"Hosts are required");
        this.withPropertyValue("hosts", hosts);
        return this;
    }

    @Nonnull
    public FromFlux withHosts(@Nonnull String[] hosts) {
        Arguments.checkNotNull((Object)hosts, (String)"Hosts are required");
        this.withPropertyValue("hosts", hosts);
        return this;
    }

    @Nonnull
    public Flux withLocationNamed(@Nonnull String name) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        this.options.location = String.format("timezone.location(name: \"%s\")", name);
        this.addImport("timezone");
        return this;
    }

    @Nonnull
    public Flux withLocationFixed(@Nonnull String offset) {
        Arguments.checkDuration((String)offset, (String)"offset");
        this.options.location = String.format("timezone.fixed(offset: %s)", offset);
        this.addImport("timezone");
        return this;
    }

    @Override
    public void appendActual(@Nonnull Map<String, Object> parameters, @Nonnull StringBuilder builder) {
        if (this.options.location != null) {
            builder.append("option location = ");
            builder.append(this.options.location);
            builder.append("\n");
        }
        super.appendActual(parameters, builder);
    }

    @Override
    void appendDelimiter(@Nonnull StringBuilder builder) {
    }

    private static class FluxOptions {
        private String location;

        private FluxOptions() {
        }
    }
}

