/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftarcadiainternal.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.redshiftarcadiainternal.model.VpcEndpoint;
import com.amazonaws.services.redshiftarcadiainternal.model.transform.EndpointMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Endpoint
implements Serializable,
Cloneable,
StructuredPojo {
    private String address;
    private Integer port;
    private SdkInternalList<VpcEndpoint> vpcEndpoints;

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public Endpoint withAddress(String address) {
        this.setAddress(address);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public Endpoint withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public List<VpcEndpoint> getVpcEndpoints() {
        if (this.vpcEndpoints == null) {
            this.vpcEndpoints = new SdkInternalList();
        }
        return this.vpcEndpoints;
    }

    public void setVpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
        if (vpcEndpoints == null) {
            this.vpcEndpoints = null;
            return;
        }
        this.vpcEndpoints = new SdkInternalList(vpcEndpoints);
    }

    public Endpoint withVpcEndpoints(VpcEndpoint ... vpcEndpoints) {
        if (this.vpcEndpoints == null) {
            this.setVpcEndpoints((Collection<VpcEndpoint>)new SdkInternalList(vpcEndpoints.length));
        }
        for (VpcEndpoint ele : vpcEndpoints) {
            this.vpcEndpoints.add((Object)ele);
        }
        return this;
    }

    public Endpoint withVpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
        this.setVpcEndpoints(vpcEndpoints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAddress() != null) {
            sb.append("Address: ").append(this.getAddress()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getVpcEndpoints() != null) {
            sb.append("VpcEndpoints: ").append(this.getVpcEndpoints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (other.getAddress() == null ^ this.getAddress() == null) {
            return false;
        }
        if (other.getAddress() != null && !other.getAddress().equals(this.getAddress())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getVpcEndpoints() == null ^ this.getVpcEndpoints() == null) {
            return false;
        }
        return other.getVpcEndpoints() == null || other.getVpcEndpoints().equals(this.getVpcEndpoints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAddress() == null ? 0 : this.getAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpoints() == null ? 0 : this.getVpcEndpoints().hashCode());
        return hashCode;
    }

    public Endpoint clone() {
        try {
            return (Endpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

