/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.support;

import com.simba.athena.support.EscapeTypes;
import com.simba.athena.support.IReplacer;
import com.simba.athena.support.IReplacerChecked;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCEscaper {
    private static final int RETYPE_NAME = 1;
    private static final int RETYPE_VALUE = 2;
    private static final int RETYPE_LIMIT = 3;
    private static final int RETYPE_OFFSET = 4;
    private static final int RETYPE_FNAME = 5;
    private static final int RETYPE_ARGIND = 6;
    private static final int RETYPE_LAST = 6;
    private static final int LIKEESCAPE_PATTERN = 2;
    private static final String WS = " \\s* ";
    private static final String QWORD = "\\[ [^\\]]* \\] ";
    private static final String QNUM = "\\? | \\d+";
    private static final String CCB = "[}]";
    private static final String ARGIND = "[(] |[}]";
    private static final int flags = 14;
    private static final Pattern s_re_scan = Pattern.compile("(?:           \" [^\"]* \" |      \\b E   ' (?: \\\\.  |  [^'] )* ' | (?<! \\b E ) ' [^']*   ' |  \\[ [^\\]]* \\] | -- [^\\n]*   $| /[*]  (?: [^/] | (?<= [^*]) / )*  \\*/| (?! \\b ( CONVERT \\( | LIKE \\b) ) [^$,{?}()] | [^$,{?}()] )*", 14);
    private static final Pattern s_re_type = Pattern.compile(" \\s* (  (?:    (?: d | escape | guid | interval | ts | t ) \\s*     ( (?: - \\s* )?      ' [^']* '      [-().,:/\\s\\w]*    )  ) \\s* [}]| (?:limit \\s* (\\? | \\d+) (?:  \\s*  offset  \\s*  (\\? | \\d+) )? ) \\s* [}]| oj | (?: call | fn | [?] \\s* = \\s* call ) \\s*   ( [\\w.]+   | \" [^\"]* \"    | \\[ [^\\]]* \\]  (?:  \\s* [.] \\s* \\[ [^\\]]* \\]  )*  ) \\s*   ( [(] |[}] )) \\s* ", 14);
    private static final Pattern s_re_likeEscape = Pattern.compile("(LIKE(\\s)*((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+))((?:(\\s)+ESCAPE(\\s)+((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+))|(\\s)*\\{(\\s)*ESCAPE(\\s)+((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+)(\\s)*\\})", 14);
    private String m_query;
    private Matcher scanMatcher;
    private Matcher typeMatcher;
    private Matcher likeMatcher;

    public String Apply(IReplacer iReplacer, String string) {
        return this.Apply((IReplacerChecked)iReplacer, string);
    }

    public <T extends Throwable> String Apply(IReplacerChecked<T> iReplacerChecked, String string) throws T {
        if (string == null || string.isEmpty()) {
            return string;
        }
        assert (iReplacerChecked != null);
        StringBuilder stringBuilder = new StringBuilder();
        this.m_query = string;
        this.scanMatcher = s_re_scan.matcher(string.toUpperCase());
        this.typeMatcher = s_re_type.matcher(string.toLowerCase());
        this.likeMatcher = s_re_likeEscape.matcher(string);
        int n = this.Apply(iReplacerChecked, 0, 0, stringBuilder);
        return stringBuilder.toString();
    }

    public int Scan(String string, int n, String string2) {
        if (string == null || string.isEmpty()) {
            return 0;
        }
        this.m_query = string;
        Matcher matcher = s_re_scan.matcher(this.m_query);
        n = this.Scan(n, string2, matcher);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T extends Throwable> int Apply(IReplacerChecked<T> iReplacerChecked, int n, int n2, StringBuilder stringBuilder) throws T {
        assert (iReplacerChecked != null);
        assert (this.scanMatcher != null);
        assert (this.typeMatcher != null);
        assert (this.m_query != null);
        String string = "?{";
        EscapeTypes escapeTypes = EscapeTypes.UNKNOWN;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        StringBuilder stringBuilder2 = new StringBuilder();
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>();
        while (true) {
            block59: {
                String string2;
                int n6;
                String string3;
                block62: {
                    int n7;
                    StringBuilder stringBuilder3;
                    block57: {
                        block61: {
                            block60: {
                                block58: {
                                    n5 = this.Scan(n, string, this.scanMatcher);
                                    stringBuilder3 = "?{".equals(string) ? stringBuilder : ("}".equals(string) ? stringBuilder2 : (StringBuilder)arrayList.get(arrayList.size() - 1));
                                    if (n5 > n) {
                                        stringBuilder3.append(this.m_query.substring(n, n5));
                                    }
                                    if (n5 >= this.m_query.length()) {
                                        return n5;
                                    }
                                    if (!Character.isLetter(this.m_query.charAt(n5))) break block57;
                                    if (!string.equals(",)(}?{")) break block58;
                                    assert (n4 > 0);
                                    n5 = this.Apply(iReplacerChecked, n5, n2, stringBuilder3);
                                    break block59;
                                }
                                if ('L' == this.m_query.charAt(n5) || 'l' == this.m_query.charAt(n5)) break block60;
                                assert (n4 == 0);
                                escapeTypes = EscapeTypes.FN;
                                int n8 = n7 = this.m_query.indexOf("(", n5);
                                while (Character.isSpaceChar(this.m_query.charAt(n8 - 1))) {
                                    --n8;
                                }
                                arrayList.clear();
                                arrayList.add(new StringBuilder(this.m_query.substring(n5, n8)));
                                n5 = n7 + 1;
                                n4 = 1;
                                string = ",)(}?{";
                                break block59;
                            }
                            if (this.likeMatcher.find(n5)) break block61;
                            stringBuilder.append("LIKE");
                            n5 += 4;
                            break block59;
                        }
                        escapeTypes = EscapeTypes.LIKE_ESCAPE;
                        n7 = 2;
                        while (null == this.likeMatcher.group(n7)) {
                            ++n7;
                        }
                        stringBuilder.append(this.m_query.substring(n5, this.likeMatcher.start(n7)));
                        stringBuilder.append(" ");
                        arrayList.clear();
                        string3 = this.likeMatcher.group(n7);
                        n6 = n7 + 1;
                        break block62;
                    }
                    block0 : switch (this.m_query.charAt(n5++)) {
                        case '?': {
                            stringBuilder3.append((CharSequence)iReplacerChecked.replace(EscapeTypes.PARAM, arrayList));
                            break;
                        }
                        case '(': {
                            ++n4;
                            stringBuilder3.append('(');
                            break;
                        }
                        case ')': {
                            if (--n4 == 0 && ",)(}?{".equals(string)) {
                                string = "}";
                                break;
                            }
                            stringBuilder3.append(')');
                            break;
                        }
                        case ',': {
                            if (n4 == 1) {
                                n3 = n5;
                                arrayList.add(new StringBuilder(""));
                                break;
                            }
                            stringBuilder3.append(',');
                            break;
                        }
                        case '}': {
                            assert (!"?{".equals(string));
                            for (n7 = 1; n7 < arrayList.size(); ++n7) {
                                StringBuilder stringBuilder4 = arrayList.get(n7);
                                while (0 != stringBuilder4.length() && Character.isWhitespace(stringBuilder4.charAt(0))) {
                                    stringBuilder4.deleteCharAt(0);
                                }
                            }
                            int n9 = stringBuilder.length();
                            if (n9 > 0 && Character.isLetterOrDigit(stringBuilder.charAt(n9 - 1))) {
                                stringBuilder.append(" ");
                            }
                            stringBuilder.append((CharSequence)iReplacerChecked.replace(escapeTypes, arrayList)).append((CharSequence)stringBuilder2);
                            arrayList.clear();
                            stringBuilder2 = new StringBuilder();
                            if (n2 > 0) {
                                return n5;
                            }
                            string = "?{";
                            break;
                        }
                        case '{': {
                            int n9;
                            if (!"?{".equals(string)) {
                                n5 = this.Apply(iReplacerChecked, n5 - 1, n2 + 1, arrayList.get(arrayList.size() - 1));
                                break;
                            }
                            if (!$assertionsDisabled) {
                                if (n5 < 0) throw new AssertionError();
                                if (n5 > this.m_query.length()) {
                                    throw new AssertionError();
                                }
                            }
                            if (!this.typeMatcher.find(n5) || n5 != this.typeMatcher.start()) {
                                stringBuilder.append(this.m_query.substring(n5 - 1, this.m_query.length()));
                                return this.m_query.length();
                            }
                            n5 = this.typeMatcher.start(1);
                            switch (Character.toLowerCase(this.m_query.charAt(n5))) {
                                case 'd': {
                                    escapeTypes = EscapeTypes.DATE;
                                    break;
                                }
                                case 'e': {
                                    escapeTypes = EscapeTypes.ESCAPE;
                                    break;
                                }
                                case 'l': {
                                    escapeTypes = EscapeTypes.LIMIT_OFFSET;
                                    break;
                                }
                                case 't': {
                                    escapeTypes = Character.toLowerCase(this.m_query.charAt(n5 + 1)) == 's' ? EscapeTypes.TIMESTAMP : EscapeTypes.TIME;
                                    break;
                                }
                                case 'i': {
                                    escapeTypes = EscapeTypes.INTERVAL;
                                    break;
                                }
                                case 'o': {
                                    escapeTypes = EscapeTypes.OUTERJOIN;
                                    break;
                                }
                                case 'c': {
                                    escapeTypes = EscapeTypes.CALL;
                                    break;
                                }
                                case '?': {
                                    escapeTypes = EscapeTypes.RESULT;
                                    break;
                                }
                                case 'f': {
                                    escapeTypes = EscapeTypes.FN;
                                    break;
                                }
                                case 'g': {
                                    escapeTypes = EscapeTypes.GUID;
                                    break;
                                }
                            }
                            arrayList.clear();
                            switch (escapeTypes) {
                                case DATE: 
                                case ESCAPE: 
                                case TIME: 
                                case TIMESTAMP: 
                                case INTERVAL: 
                                case GUID: {
                                    arrayList.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(2), this.typeMatcher.end(2))));
                                    n9 = stringBuilder.length();
                                    if (n9 > 0 && Character.isLetterOrDigit(stringBuilder.charAt(n9 - 1))) {
                                        stringBuilder.append(" ");
                                    }
                                    stringBuilder.append((CharSequence)iReplacerChecked.replace(escapeTypes, arrayList));
                                    if (n2 > 0) {
                                        return this.typeMatcher.end(0);
                                    }
                                    arrayList.clear();
                                    break;
                                }
                                case LIMIT_OFFSET: {
                                    arrayList.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(3), this.typeMatcher.end(3))));
                                    if (this.typeMatcher.start(4) != -1) {
                                        arrayList.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(4), this.typeMatcher.end(4))));
                                    }
                                    stringBuilder.append((CharSequence)iReplacerChecked.replace(escapeTypes, arrayList));
                                    break;
                                }
                                case OUTERJOIN: {
                                    string = "}?{";
                                    n3 = this.typeMatcher.end(0);
                                    arrayList.add(new StringBuilder(""));
                                    break;
                                }
                                case CALL: 
                                case RESULT: 
                                case FN: {
                                    arrayList.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(5), this.typeMatcher.end(5))));
                                    n5 = this.typeMatcher.start(6);
                                    string = ",)(}?{";
                                    if (this.m_query.charAt(n5) == '}') break block0;
                                    n4 = 1;
                                    n3 = this.typeMatcher.end(0);
                                    arrayList.add(new StringBuilder(""));
                                }
                            }
                            n5 = this.typeMatcher.end(0);
                            break;
                        }
                    }
                    break block59;
                }
                while (2 > string3.length()) {
                    int n10 = this.likeMatcher.start(n6);
                    int n11 = this.likeMatcher.end(n6);
                    if (-1 != n10 && -1 != n11) {
                        string3 = this.m_query.substring(this.likeMatcher.start(n6), this.likeMatcher.end(n6++));
                        if (string3.equals("?")) {
                            string3 = iReplacerChecked.replace(EscapeTypes.PARAM, arrayList).toString();
                        }
                        if (n6 != this.likeMatcher.groupCount()) continue;
                        return this.m_query.length();
                    }
                    ++n6;
                }
                int n12 = -1;
                while (-1 == n12) {
                    n12 = this.likeMatcher.start(n6);
                    if (null == this.likeMatcher.group(n6) || 2 > this.likeMatcher.group(n6).length() || this.likeMatcher.group(n6).toUpperCase().contains("ESCAPE")) {
                        n12 = -1;
                    }
                    if (++n6 != this.likeMatcher.groupCount()) continue;
                    return this.m_query.length();
                }
                if ((string2 = this.m_query.substring(this.likeMatcher.start(--n6), this.likeMatcher.end(n6))).equals("?")) {
                    string2 = iReplacerChecked.replace(EscapeTypes.PARAM, arrayList).toString();
                }
                arrayList.add(new StringBuilder(string3));
                arrayList.add(new StringBuilder(string2));
                stringBuilder.append(iReplacerChecked.replace(escapeTypes, arrayList).toString());
                string = "?{";
                n5 = this.likeMatcher.end(0);
            }
            n = n5;
        }
    }

    private int Scan(int n, String string, Matcher matcher) {
        assert (matcher != null);
        assert (string != null);
        assert (n >= 0 && n <= this.m_query.length());
        while (matcher.find(n)) {
            int n2 = matcher.start(1);
            if (-1 == n2) {
                n2 = matcher.end(0);
            }
            if (n2 == -1 || n2 >= this.m_query.length()) {
                return this.m_query.length();
            }
            char[] cArray = string.toCharArray();
            char c = this.m_query.charAt(n2);
            if (Character.isLetter(c)) {
                return n2;
            }
            for (int i = 0; i < cArray.length; ++i) {
                if (c != cArray[i]) continue;
                return n2;
            }
            n = n2 + 1;
        }
        return this.m_query.length();
    }
}

