/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin;

import com.simba.athena.iamsupport.plugin.InternalPluginException;
import com.simba.athena.iamsupport.plugin.SamlCredentialsProvider;
import com.simba.athena.iamsupport.plugin.httpserver.RequestHandler;
import com.simba.athena.iamsupport.plugin.httpserver.Server;
import com.simba.athena.iamsupport.plugin.utils.CheckUtils;
import com.simba.athena.iamsupport.plugin.utils.LogUtils;
import com.simba.athena.iamsupport.plugin.utils.RequestProcess;
import com.simba.athena.support.LogUtilities;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;

public class BrowserSamlCredentialsProvider
extends SamlCredentialsProvider {
    public static final String KEY_LOGIN_URL = "login_url";
    public static final String KEY_IDP_RESPONSE_TIMEOUT = "idp_response_timeout";
    public static final String KEY_LISTEN_PORT = "listen_port";
    private String m_login_url;
    private int m_idp_response_timeout = 120;
    private int m_listen_port = 7890;

    @Override
    protected String getSamlAssertion() throws IOException {
        try {
            LogUtilities.logDebug("Entered", LogUtils.getLogger());
            CheckUtils.checkMissingAndThrows(this.m_login_url, KEY_LOGIN_URL);
            CheckUtils.checkAndThrowsWithMessage(this.m_idp_response_timeout < 10, "idp_response_timeout should be 10 seconds or greater.");
            CheckUtils.checkInvalidAndThrows(this.m_listen_port < 1 || this.m_listen_port > 65535, KEY_LISTEN_PORT);
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            return this.authenticate();
        }
        catch (InternalPluginException internalPluginException) {
            throw new IOException(internalPluginException);
        }
    }

    @Override
    public void addParameter(String string, String string2) {
        switch (string) {
            case "listen_port": {
                this.m_listen_port = Integer.parseInt(string2);
                break;
            }
            case "login_url": {
                this.m_login_url = string2;
                break;
            }
            case "idp_response_timeout": {
                this.m_idp_response_timeout = Integer.parseInt(string2);
                break;
            }
            default: {
                super.addParameter(string, string2);
            }
        }
    }

    private String authenticate() throws IOException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        RequestProcess requestProcess = new RequestProcess();
        RequestHandler requestHandler = new RequestHandler(requestProcess);
        URI uRI = this.prepareAndVerifyURI();
        Server server = new Server(this.m_listen_port, requestHandler, this.m_idp_response_timeout);
        server.listen();
        LogUtilities.logInfo(String.format("Listening for connection on port %d", this.m_listen_port), LogUtils.getLogger());
        try {
            this.openBrowser(uRI);
            server.waitForResult();
        }
        catch (IOException iOException) {
            server.stop();
            throw iOException;
        }
        server.waitForResult();
        Object object = requestHandler.getResult();
        if (object instanceof InternalPluginException) {
            throw (InternalPluginException)object;
        }
        if (object instanceof String) {
            LogUtilities.logInfo("Got SAML assertion", LogUtils.getLogger());
            LogUtilities.logDebug(String.format("Exiting with return result value {%s}", object), LogUtils.getLogger());
            return (String)object;
        }
        LogUtilities.logDebug("Exiting with timeout", LogUtils.getLogger());
        throw new InternalPluginException("Fail to login during timeout.");
    }

    private void openBrowser(URI uRI) throws IOException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        Desktop.getDesktop().browse(uRI);
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
    }

    private URI prepareAndVerifyURI() throws IOException {
        URI uRI = URI.create(this.m_login_url);
        LogUtilities.logDebug(String.format("SSO URI: \n%s", uRI.toString()), LogUtils.getLogger());
        this.validateURL(uRI.toString());
        return uRI;
    }
}

