/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin;

import com.simba.athena.amazonaws.util.StringUtils;
import com.simba.athena.amazonaws.util.json.Jackson;
import com.simba.athena.iamsupport.plugin.InternalPluginException;
import com.simba.athena.iamsupport.plugin.SamlCredentialsProvider;
import com.simba.athena.iamsupport.plugin.httpserver.RequestHandler;
import com.simba.athena.iamsupport.plugin.httpserver.Server;
import com.simba.athena.iamsupport.plugin.utils.CheckUtils;
import com.simba.athena.iamsupport.plugin.utils.LogUtils;
import com.simba.athena.iamsupport.plugin.utils.RandomStateUtil;
import com.simba.athena.iamsupport.plugin.utils.RequestProcess;
import com.simba.athena.shaded.fasterxml.jackson.databind.JsonNode;
import com.simba.athena.support.LogUtilities;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class BrowserAzureCredentialsProvider
extends SamlCredentialsProvider {
    public static final String KEY_IDP_RESPONSE_TIMEOUT = "idp_response_timeout";
    public static final String KEY_LISTEN_PORT = "listen_port";
    public static final String KEY_TENANT_ID = "tenant_id";
    public static final String KEY_CLIENT_ID = "client_id";
    public static final String KEY_CLIENT_SECRET = "client_secret";
    public static final String OAUTH_STATE_PARAMETER_NAME = "state";
    public static final String OAUTH_REDIRECT_PARAMETER_NAME = "redirect_uri";
    public static final String OAUTH_IDP_CODE_PARAMETER_NAME = "code";
    public static final String OAUTH_CLIENT_ID_PARAMETER_NAME = "client_id";
    public static final String OAUTH_CLIENT_SECRET_PARAMETER_NAME = "client_secret";
    public static final String OAUTH_RESPONSE_TYPE_PARAMETER_NAME = "response_type";
    public static final String OAUTH_REQUESTED_TOKEN_TYPE_PARAMETER_NAME = "requested_token_type";
    public static final String OAUTH_GRANT_TYPE_PARAMETER_NAME = "grant_type";
    public static final String OAUTH_SCOPE_PARAMETER_NAME = "scope";
    public static final String OAUTH_RESOURCE_PARAMETER_NAME = "resource";
    public static final String OAUTH_RESPONSE_MODE_PARAMETER_NAME = "response_mode";
    private static final String CURRENT_INTERACTION_SCHEMA = "https";
    private String m_idp_tenant;
    private String m_clientId;
    private String m_clientSecret = null;
    private int m_idp_response_timeout = 120;
    private int m_listen_port = 0;
    private String redirectUri;

    @Override
    protected String getSamlAssertion() throws IOException {
        try {
            LogUtilities.logDebug("Entered", LogUtils.getLogger());
            CheckUtils.checkMissingAndThrows(this.m_idp_tenant, KEY_TENANT_ID);
            CheckUtils.checkMissingAndThrows(this.m_clientId, "client_id");
            CheckUtils.checkAndThrowsWithMessage(this.m_idp_response_timeout < 10, "idp_response_timeout should be 10 seconds or greater.");
            CheckUtils.checkInvalidAndThrows(this.m_listen_port != 0 && (this.m_listen_port < 1 || this.m_listen_port > 65535), KEY_LISTEN_PORT);
            if (this.m_listen_port == 0) {
                LogUtilities.logDebug("Listen port set to 0. Will pick random port", LogUtils.getLogger());
            }
            String string = this.fetchAuthorizationToken();
            String string2 = this.fetchSamlResponse(string);
            String string3 = this.extractSamlAssertion(string2);
            LogUtilities.logDebug(String.format("Exiting with return value {%s}", string3), LogUtils.getLogger());
            return this.wrapAndEncodeAssertion(string3);
        }
        catch (InternalPluginException | URISyntaxException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void addParameter(String string, String string2) {
        switch (string) {
            case "tenant_id": {
                this.m_idp_tenant = string2;
                break;
            }
            case "client_id": {
                this.m_clientId = string2;
                break;
            }
            case "client_secret": {
                this.m_clientSecret = string2;
                break;
            }
            case "idp_response_timeout": {
                this.m_idp_response_timeout = Integer.parseInt(string2);
                break;
            }
            case "listen_port": {
                this.m_listen_port = Integer.parseInt(string2);
                break;
            }
            default: {
                super.addParameter(string, string2);
            }
        }
    }

    private String fetchAuthorizationToken() throws IOException, URISyntaxException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        String string = RandomStateUtil.generateRandomState();
        RequestProcess requestProcess = new RequestProcess();
        requestProcess.setState(string);
        RequestHandler requestHandler = new RequestHandler(requestProcess);
        URI uRI = this.prepareAndValidateURI(string);
        Server server = new Server(this.m_listen_port, requestHandler, this.m_idp_response_timeout);
        server.listen();
        int n = server.getLocalPort();
        this.redirectUri = "http://localhost:" + n + "/athena";
        try {
            LogUtilities.logInfo(String.format("Listening for connection on port %d", n), LogUtils.getLogger());
            this.openBrowser(uRI);
            server.waitForResult();
        }
        catch (IOException | URISyntaxException exception) {
            server.stop();
            throw exception;
        }
        Object object = requestHandler.getResult();
        if (object instanceof InternalPluginException) {
            throw (InternalPluginException)object;
        }
        if (object instanceof String) {
            LogUtilities.logInfo(String.format("Got SAML assertion with {%s}", object), LogUtils.getLogger());
            return (String)object;
        }
        LogUtilities.logDebug("Throwing timeout", LogUtils.getLogger());
        throw new InternalPluginException("Fail to login during timeout.");
    }

    private String wrapAndEncodeAssertion(String string) {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        String string2 = "<samlp:Response xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"><samlp:Status><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/></samlp:Status>" + string + "</samlp:Response>";
        LogUtilities.logDebug(String.format("Exiting with return value {%s}", string2), LogUtils.getLogger());
        return org.apache.commons.codec.binary.StringUtils.newStringUtf8(Base64.encodeBase64(string2.getBytes()));
    }

    private String fetchSamlResponse(String string) throws IOException {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        boolean bl = false;
        HttpPost httpPost = this.createAuthorizationRequest(string);
        try {
            Object object;
            Object object2;
            CloseableHttpClient closeableHttpClient = this.getHttpClient();
            bl = this.CheckNonProxyHost("login.microsoftonline.com", this.m_nonProxyHosts);
            if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue() && !bl) {
                if (this.m_proxyUid != null && !this.m_proxyUid.isEmpty() && this.m_proxyPwd != null && !this.m_proxyPwd.isEmpty()) {
                    object2 = new BasicCredentialsProvider();
                    object2.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                    closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object2).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                }
                object2 = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                object = RequestConfig.custom().setProxy((HttpHost)object2).build();
                httpPost.setConfig((RequestConfig)object);
            }
            CheckUtils.checkAndThrowsWithMessage((object2 = closeableHttpClient.execute(httpPost)).getStatusLine().getStatusCode() != 200, "Unexpected response:  " + object2.getStatusLine().getReasonPhrase());
            object = EntityUtils.toString(object2.getEntity());
            LogUtilities.logDebug(String.format("Exiting with return value {%s}", object), LogUtils.getLogger());
            return object;
        }
        catch (GeneralSecurityException generalSecurityException) {
            LogUtilities.logError(generalSecurityException, LogUtils.getLogger());
            throw new InternalPluginException(generalSecurityException);
        }
    }

    private String extractSamlAssertion(String string) {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        JsonNode jsonNode = Jackson.jsonNodeOf(string).findValue("access_token");
        CheckUtils.checkAndThrowsWithMessage(jsonNode == null, "Failed to find access_token");
        String string2 = jsonNode.textValue();
        CheckUtils.checkAndThrowsWithMessage(StringUtils.isNullOrEmpty(string2), "Invalid access_token value.");
        LogUtilities.logInfo("Successfully got SAML assertion", LogUtils.getLogger());
        LogUtilities.logDebug(String.format("Exiting with return value {%s}", string2), LogUtils.getLogger());
        return org.apache.commons.codec.binary.StringUtils.newStringUtf8(Base64.decodeBase64(string2));
    }

    private HttpPost createAuthorizationRequest(String string) throws IOException {
        Cloneable cloneable;
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        URIBuilder uRIBuilder = new URIBuilder().setScheme(CURRENT_INTERACTION_SCHEMA).setHost("login.microsoftonline.com").setPath("/" + this.m_idp_tenant + "/oauth2/token");
        String string2 = uRIBuilder.toString();
        this.validateURL(string2);
        HttpPost httpPost = new HttpPost(string2);
        LogUtilities.logDebug(String.format("ProxyHost={%s},ProxyPort={%d},UseProxyforIdp={%b}", this.m_proxyHost, this.m_proxyPort, this.m_useProxyForIdpAuth), LogUtils.getLogger());
        LogUtilities.logDebug(String.format("UserName={%s},Password={%s},NonProxyHosts={%s}", this.m_userName, this.m_password, this.m_nonProxyHosts), LogUtils.getLogger());
        if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
            LogUtilities.logDebug("Setting Proxy", LogUtils.getLogger());
            cloneable = new HttpHost(this.m_proxyHost, this.m_proxyPort);
            RequestConfig requestConfig = RequestConfig.custom().setProxy((HttpHost)cloneable).build();
            httpPost.setConfig(requestConfig);
        }
        cloneable = new ArrayList<BasicNameValuePair>();
        cloneable.add(new BasicNameValuePair(OAUTH_IDP_CODE_PARAMETER_NAME, string));
        cloneable.add(new BasicNameValuePair(OAUTH_REQUESTED_TOKEN_TYPE_PARAMETER_NAME, "urn:ietf:params:oauth:token-type:saml2"));
        cloneable.add(new BasicNameValuePair(OAUTH_GRANT_TYPE_PARAMETER_NAME, "authorization_code"));
        cloneable.add(new BasicNameValuePair(OAUTH_SCOPE_PARAMETER_NAME, "openid"));
        cloneable.add(new BasicNameValuePair(OAUTH_RESOURCE_PARAMETER_NAME, this.m_clientId));
        cloneable.add(new BasicNameValuePair("client_id", this.m_clientId));
        cloneable.add(new BasicNameValuePair(OAUTH_REDIRECT_PARAMETER_NAME, this.redirectUri));
        if (null != this.m_clientSecret) {
            cloneable.add(new BasicNameValuePair("client_secret", this.m_clientSecret));
        }
        httpPost.addHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
        httpPost.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
        httpPost.setEntity(new UrlEncodedFormEntity((Iterable<? extends NameValuePair>)((Object)cloneable), Charsets.UTF_8));
        LogUtilities.logDebug(String.format("Request token URI: \n%s\nRequest parameters:\n%s", string2, Arrays.toString(cloneable.toArray())), LogUtils.getLogger());
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return httpPost;
    }

    private void openBrowser(URI uRI) throws URISyntaxException, IOException {
        Desktop.getDesktop().browse(uRI);
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
    }

    private URI prepareAndValidateURI(String string) throws URISyntaxException, IOException {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        URIBuilder uRIBuilder = new URIBuilder().setScheme(CURRENT_INTERACTION_SCHEMA).setHost("login.microsoftonline.com").setPath("/" + this.m_idp_tenant + "/oauth2/authorize").addParameter(OAUTH_SCOPE_PARAMETER_NAME, "openid").addParameter(OAUTH_RESPONSE_TYPE_PARAMETER_NAME, OAUTH_IDP_CODE_PARAMETER_NAME).addParameter(OAUTH_RESPONSE_MODE_PARAMETER_NAME, "form_post").addParameter("client_id", this.m_clientId).addParameter(OAUTH_REDIRECT_PARAMETER_NAME, this.redirectUri).addParameter(OAUTH_STATE_PARAMETER_NAME, string);
        URI uRI = uRIBuilder.build();
        LogUtilities.logDebug(String.format("Authorization code request URI: \n%s", uRI.toString()), LogUtils.getLogger());
        this.validateURL(uRI.toString());
        return uRI;
    }
}

