/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.util.IOUtils;
import com.simba.athena.amazonaws.util.StringUtils;
import com.simba.athena.iamsupport.model.CredentialsHolder;
import com.simba.athena.iamsupport.plugin.SamlCredentialsProvider;
import com.simba.athena.iamsupport.plugin.utils.LogUtils;
import com.simba.athena.support.LogUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class AdfsCredentialsProvider
extends SamlCredentialsProvider {
    private static final Pattern SAML_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"([^\"]+)\"");

    @Override
    protected String getSamlAssertion() throws IOException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        if (StringUtils.isNullOrEmpty(this.m_idpHost)) {
            throw new IOException("Missing required property: idp_host");
        }
        if (StringUtils.isNullOrEmpty(this.m_userName) || StringUtils.isNullOrEmpty(this.m_password)) {
            return this.windowsIntegratedAuthentication();
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return this.formBasedAuthentication();
    }

    @Override
    protected CredentialsHolder performPostSAMLAction(String string, String string2, CredentialsHolder credentialsHolder) throws SdkClientException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractExecutable() throws IOException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        File file = File.createTempFile("adfs", ".exe");
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = AdfsCredentialsProvider.class.getResourceAsStream("adfs.exe");
            fileOutputStream = new FileOutputStream(file);
            IOUtils.copy(inputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream, null);
            IOUtils.closeQuietly(fileOutputStream, null);
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream, null);
        IOUtils.closeQuietly(fileOutputStream, null);
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return file;
    }

    private String formBasedAuthentication() throws IOException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        String string = "https://" + this.m_idpHost + ':' + this.m_idpPort + "/adfs/ls/IdpInitiatedSignOn.aspx?loginToRp=urn:amazon:webservices";
        this.validateURL(string);
        CloseableHttpClient closeableHttpClient = null;
        try {
            Object object;
            Object object2;
            Header[] headerArray;
            Cloneable cloneable;
            Object object4;
            Object object5;
            boolean bl = false;
            closeableHttpClient = this.getHttpClient();
            HttpGet httpGet = new HttpGet(string);
            if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue() && this.m_proxyUid != null && !this.m_proxyUid.isEmpty() && this.m_proxyPwd != null && !this.m_proxyPwd.isEmpty()) {
                object5 = new BasicCredentialsProvider();
                object5.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object5).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                object4 = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                cloneable = RequestConfig.custom().setProxy((HttpHost)object4).build();
                httpGet.setConfig((RequestConfig)cloneable);
            }
            if ((object5 = closeableHttpClient.execute(httpGet)).getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + object5.getStatusLine().getReasonPhrase());
            }
            object4 = EntityUtils.toString(object5.getEntity());
            cloneable = new ArrayList<BasicNameValuePair>();
            for (String object32 : this.getInputTagsfromHTML((String)object4)) {
                headerArray = this.getValueByKey(object32, "name");
                object2 = this.getValueByKey(object32, "value");
                object = headerArray.toLowerCase();
                if (((String)object).contains("username")) {
                    if (cloneable.contains(new BasicNameValuePair((String)headerArray, this.m_userName))) continue;
                    cloneable.add(new BasicNameValuePair((String)headerArray, this.m_userName));
                    continue;
                }
                if (((String)object).contains("authmethod")) {
                    if (((String)object2).isEmpty()) continue;
                    cloneable.add(new BasicNameValuePair((String)headerArray, (String)object2));
                    continue;
                }
                if (((String)object).contains("password")) {
                    cloneable.add(new BasicNameValuePair((String)headerArray, this.m_password));
                    continue;
                }
                if (headerArray.isEmpty()) continue;
                cloneable.add(new BasicNameValuePair((String)headerArray, (String)object2));
            }
            String string2 = this.getFormAction((String)object4);
            if (!StringUtils.isNullOrEmpty(string2) && string2.startsWith("/")) {
                string = "https://" + this.m_idpHost + ':' + this.m_idpPort + (String)string2;
            }
            HttpPost httpPost = new HttpPost(string);
            httpPost.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)((Object)cloneable)));
            if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
                headerArray = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                object2 = RequestConfig.custom().setProxy((HttpHost)headerArray).build();
                httpPost.setConfig((RequestConfig)object2);
            }
            if ((object5 = closeableHttpClient.execute(httpPost)).getStatusLine().getStatusCode() != 200) {
                if (object5.getStatusLine().getStatusCode() == 302) {
                    headerArray = object5.getHeaders("Location");
                    object2 = null;
                    if (headerArray != null && headerArray.length > 0) {
                        object2 = headerArray[0].getValue();
                        bl = this.CheckNonProxyHost((String)object2, this.m_nonProxyHosts);
                        if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue() && !bl) {
                            if (this.m_proxyUid != null && !this.m_proxyUid.isEmpty() && this.m_proxyPwd != null && !this.m_proxyPwd.isEmpty()) {
                                object = new BasicCredentialsProvider();
                                object.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                            }
                            object = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                            RequestConfig requestConfig = RequestConfig.custom().setProxy((HttpHost)object).build();
                            httpPost.setConfig(requestConfig);
                        }
                        object5 = closeableHttpClient.execute(new HttpPost((String)object2));
                    }
                } else {
                    throw new IOException("Failed send request: " + object5.getStatusLine().getReasonPhrase());
                }
            }
            if (!((Matcher)(object2 = SAML_PATTERN.matcher((CharSequence)(headerArray = EntityUtils.toString(object5.getEntity()))))).find()) {
                throw new IOException("Failed to login ADFS.");
            }
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            object = ((Matcher)object2).group(1);
            return object;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SdkClientException("Failed create SSLContext.", generalSecurityException);
        }
        finally {
            IOUtils.closeQuietly(closeableHttpClient, null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String windowsIntegratedAuthentication() {
        String string;
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        String string2 = System.getProperty("os.name").toLowerCase(Locale.getDefault());
        if (!string2.contains("windows")) {
            throw new SdkClientException("WIA only support Windows platform.");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        File file = null;
        try {
            file = this.extractExecutable();
            String[] stringArray = new String[5];
            stringArray[0] = file.getAbsolutePath();
            stringArray[1] = "https://" + this.m_idpHost + ':' + this.m_idpPort + "/adfs/ls/IdpInitiatedSignOn.aspx?loginToRp=urn:amazon:webservices";
            this.validateURL(stringArray[1]);
            stringArray[2] = String.valueOf(Boolean.getBoolean("adfs.insecure"));
            if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty() && this.m_useProxyForIdpAuth.booleanValue()) {
                stringArray[3] = this.m_proxyUid;
                stringArray[4] = this.m_proxyPwd;
            }
            Process process = Runtime.getRuntime().exec(stringArray);
            inputStream = process.getInputStream();
            outputStream = process.getOutputStream();
            String string3 = IOUtils.toString(inputStream);
            int n = process.waitFor();
            if (n != 0) {
                throw new SdkClientException("Failed execute adfs command, return: " + n);
            }
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            string = string3;
        }
        catch (InterruptedException interruptedException) {
            try {
                throw new SdkClientException("Failed execute adfs command.", interruptedException);
                catch (IOException iOException) {
                    throw new SdkClientException("Failed execute adfs command.", iOException);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream, null);
                IOUtils.closeQuietly(outputStream, null);
                if (file != null && !file.delete()) {
                    file.deleteOnExit();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream, null);
        IOUtils.closeQuietly(outputStream, null);
        if (file != null && !file.delete()) {
            file.deleteOnExit();
        }
        return string;
    }
}

