/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.core.utilities.impl.future;

import com.simba.athena.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.athena.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.simba.athena.dsi.dataengine.utilities.TimeTz;
import com.simba.athena.dsi.dataengine.utilities.TypeMetadata;
import com.simba.athena.dsi.exceptions.ConversionFailed;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.exceptions.ErrorException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class TimeJDBCDataSink
extends ConvertingJDBCDataSink {
    private final int m_fractionalSecondsPrecision;

    public TimeJDBCDataSink(IWarningListener iWarningListener, TypeMetadata typeMetadata) {
        super(iWarningListener);
        this.m_fractionalSecondsPrecision = typeMetadata.getPrecision();
        assert (this.m_fractionalSecondsPrecision >= 0 && this.m_fractionalSecondsPrecision <= 3);
    }

    protected final int getFractionalSecondsPrecision() {
        return this.m_fractionalSecondsPrecision;
    }

    protected abstract void doSet(Time var1, Calendar var2) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object != null && !(object instanceof Time)) {
            throw new IncorrectTypeException();
        }
        this.doSet((Time)object, this.getLocalCalendarForConversions());
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 92: 
            case 93: 
            case 2000: {
                this.doSet(null, null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            this.setTime(NonTrivialJDBCConversions.stringToTime(string, this.m_fractionalSecondsPrecision, this.getLocalCalendarForConversions()), this.getLocalCalendarForConversions());
        }
    }

    @Override
    public void setTime(Time time, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (time instanceof TimeTz) {
            time = ((TimeTz)time).getAdjustedTime();
        }
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        this.doSet(time, calendar);
    }

    @Override
    public void setTimestamp(Timestamp timestamp, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (timestamp == null) {
            this.setNull(93);
        } else {
            if (calendar == null) {
                calendar = this.getLocalCalendarForConversions();
            }
            this.setTime(NonTrivialJDBCConversions.timestampToTime(timestamp, this.m_fractionalSecondsPrecision, calendar), calendar);
        }
    }
}

