/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine;

import com.simba.athena.amazonaws.services.athenastreamingservice.model.GetQueryResultsStreamResult;
import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.api.AJExecutionContext;
import com.simba.athena.athena.core.AJConnection;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.core.AJStatement;
import com.simba.athena.athena.dataengine.AJDataEngineUtils;
import com.simba.athena.athena.dataengine.AJReplacer;
import com.simba.athena.athena.dataengine.AJResultSet;
import com.simba.athena.athena.dataengine.AJResultSetBuffer;
import com.simba.athena.athena.dataengine.AJStatementType;
import com.simba.athena.athena.dataengine.AJStreamResultSet;
import com.simba.athena.dsi.dataengine.impl.DSIEmptyResultSet;
import com.simba.athena.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.simba.athena.dsi.dataengine.interfaces.IQueryExecutor;
import com.simba.athena.dsi.dataengine.utilities.ExecutionContexts;
import com.simba.athena.dsi.dataengine.utilities.ExecutionResults;
import com.simba.athena.dsi.dataengine.utilities.Nullable;
import com.simba.athena.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.athena.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.athena.dsi.dataengine.utilities.ParameterType;
import com.simba.athena.dsi.dataengine.utilities.TypeMetadata;
import com.simba.athena.dsi.dataengine.utilities.TypeUtilities;
import com.simba.athena.dsi.exceptions.BadDefaultParamException;
import com.simba.athena.dsi.exceptions.ExecutingException;
import com.simba.athena.dsi.exceptions.OperationCanceledException;
import com.simba.athena.dsi.exceptions.ParsingException;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.JDBCEscaper;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Map;

public class AJQueryExecutor
implements IQueryExecutor {
    private static final String DYNAMICVAL_SYMBOL = "?";
    private ILogger m_logger;
    private IWarningListener m_warningListener;
    private AJConnection m_connection;
    private AJStatement m_statement;
    private AJClient m_client;
    private final AJSettings m_settings;
    private final String m_catalog;
    private String m_query;
    private boolean m_isParamsInitialized;
    private AJResultSetBuffer m_resultBuffer = new AJResultSetBuffer();
    private AJStatementType m_stmtType;
    private AJExecutionContext m_execContext = new AJExecutionContext();
    private ExecutionResults m_results = new ExecutionResults();
    private ArrayList<ParameterMetadata> m_parameters = new ArrayList();
    private AJReplacer m_ajReplacer;

    public AJQueryExecutor(ILogger iLogger, IWarningListener iWarningListener, AJConnection aJConnection, AJSettings aJSettings, String string, JDBCEscaper jDBCEscaper, String string2, AJStatement aJStatement, AJStatementType aJStatementType, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_warningListener = iWarningListener;
        this.m_connection = aJConnection;
        this.m_client = this.m_connection.getClient();
        this.m_settings = aJSettings;
        this.m_catalog = string;
        this.m_query = string2;
        this.m_stmtType = aJStatementType;
        this.m_statement = aJStatement;
        this.m_execContext.m_statement = this.m_statement;
        this.m_execContext.m_fetchWithStream = false;
        this.m_isParamsInitialized = false;
        this.m_statement.getQueryInfoHandler().setQueryId(null);
        this.m_statement.getQueryInfoHandler().setPreparedQueryId(null);
        this.m_ajReplacer = new AJReplacer(true);
        if (AJStatementType.ROW_COUNT_STATEMENT != aJStatementType) {
            if (!bl && AJStatementType.SELECT_OR_VALUES_STATEMENT == aJStatementType) {
                this.m_client.prepareStatement(this.m_statement, this.m_query, this.m_connection);
                this.m_execContext.setQuery("SELECT * FROM (" + jDBCEscaper.Apply(this.m_ajReplacer, this.m_query) + ") T LIMIT 0");
                this.m_execContext.m_isLimit0Query = true;
                this.m_client.executeQuery(this.m_execContext, this.m_catalog);
                this.m_results.addResultSet(new AJResultSet(this.m_logger, this.m_warningListener, this.m_connection, this.m_settings, this.m_execContext, this.m_stmtType));
            } else {
                this.m_ajReplacer = new AJReplacer(false);
                this.m_query = jDBCEscaper.Apply(this.m_ajReplacer, this.m_query);
                this.m_results.addResultSet(new DSIEmptyResultSet());
            }
        } else {
            if (this.m_query.contains(DYNAMICVAL_SYMBOL)) {
                this.m_client.prepareStatement(this.m_statement, this.m_query, this.m_connection);
                this.m_execContext.setQuery(jDBCEscaper.Apply(this.m_ajReplacer, this.m_query));
                this.m_execContext.m_isLimit0Query = true;
            }
            this.m_results.addRowCountResult(new DSISimpleRowCountResult(-1L));
        }
    }

    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_client.clearCancel(this.m_execContext);
    }

    @Override
    public void cancelExecute() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_client.cancelQuery(this.m_execContext);
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, executionContexts, iWarningListener);
        if (!this.m_client.checkCancelFlag(this.m_execContext)) {
            this.m_results.getResults().clear();
            if (null != this.m_statement.getPrepareStatement() && !this.m_statement.getPrepareStatement().isEmpty()) {
                this.m_query = "EXECUTE " + this.m_statement.getPrepareStatement();
                if (executionContexts.getMetadata().size() > 0) {
                    this.m_query = this.m_query + " USING " + AJDataEngineUtils.constructParameterList(executionContexts, this.m_settings, this.m_logger);
                }
            }
            this.m_execContext.setQuery(this.m_query);
            this.m_execContext.m_isLimit0Query = false;
            this.m_client.executeQuery(this.m_execContext, this.m_catalog);
            this.m_execContext.m_fetchWithStream = this.m_settings.m_useStreamClient;
            if (AJStatementType.PREPARE_OR_DEALLOCATE_STATEMENT == this.m_stmtType) {
                this.m_results.addResultSet(new DSIEmptyResultSet());
                return;
            }
            if (AJStatementType.ROW_COUNT_STATEMENT != this.m_stmtType) {
                if (this.m_execContext.m_fetchWithStream) {
                    this.m_results.addResultSet(new AJStreamResultSet(this.m_logger, this.m_warningListener, this.m_connection, this.m_settings, this.m_execContext, this.m_stmtType));
                } else {
                    this.m_results.addResultSet(new AJResultSet(this.m_logger, this.m_warningListener, this.m_connection, this.m_settings, this.m_execContext, this.m_stmtType));
                }
            } else {
                Long l = -1L;
                if (this.m_execContext.m_fetchWithStream) {
                    GetQueryResultsStreamResult getQueryResultsStreamResult = this.m_client.fetchStreamResults(this.m_execContext);
                    l = getQueryResultsStreamResult.getUpdateCount();
                } else {
                    l = this.m_client.getUpdateCountNonStream(this.m_execContext);
                }
                this.m_results.addRowCountResult(new DSISimpleRowCountResult(l));
            }
        }
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_isParamsInitialized) {
            for (int i = 0; i < this.m_ajReplacer.getNumParams(); ++i) {
                this.m_parameters.add(new ParameterMetadata(i + 1, ParameterType.INPUT, 4));
            }
            this.m_isParamsInitialized = true;
        }
        return this.m_parameters;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_parameters.size();
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_results;
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, parameterInputValue);
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Integer n = null;
        for (Map.Entry<Integer, TypeMetadata> entry : map.entrySet()) {
            n = entry.getKey();
            long l = 0L;
            short s = entry.getValue().getType();
            if (s == 1 || s == -8) {
                l = 65535L;
            } else if (s == 12 || s == -9 || s == -1 || s == -10) {
                l = 65535L;
            } else if (TypeUtilities.isBinaryType(s)) {
                l = 32767L;
            }
            ParameterMetadata parameterMetadata = new ParameterMetadata(n + 1, ParameterType.INPUT, entry.getValue(), l, null, true, Nullable.NULLABLE);
            this.m_parameters.set(n, parameterMetadata);
        }
    }
}

