/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.core;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class AJCoreUtils {
    private static final String HOST_DELIMITER = "//";
    private static final String KEY_VALUE_DELIMITER = ";";
    private static final String VALUE_DELIMITER = "=";
    private static final Integer SPLIT_LIMIT = 2;
    private static final String REGION_DELIMITER = "\\.";
    private static final String ATHENA_ENDPOINT_VPC = "vpce";
    private static final String ATHENA_ENDPOINT_END = "amazonaws";
    private static final String ATHENA_ENDPOINT_PORT = "com:443";
    private static final String ATHENA_ENDPOINT_PORT_WITH_BACKSLASH = "com:443/";
    private static final String ATHENA_CHINA_ENDPOINT_PORT = "cn:443";
    private static final String ATHENA_CHINA_ENDPOINT_PORT_WITH_BACKSLASH = "cn:443/";
    private static final String BACKSLASH_DELIMITER = "/";

    public static boolean parseSubName(String string, Properties properties) {
        Object object;
        if (null == string || 0 == string.length() || !string.startsWith(HOST_DELIMITER)) {
            return false;
        }
        String string2 = string.trim().substring(HOST_DELIMITER.length());
        if (0 == string2.length()) {
            return false;
        }
        TreeMap<Object, String> treeMap = new TreeMap<Object, String>(String.CASE_INSENSITIVE_ORDER);
        String[] stringArray = string2.split(KEY_VALUE_DELIMITER);
        for (int i = 0; i < stringArray.length; ++i) {
            if (0 == i) {
                object = AJCoreUtils.parseRegionAndCatalogFromEndoint(stringArray[i]);
                if (null != object[0]) {
                    treeMap.put("RegionFromEndpoint", object[0]);
                    treeMap.put("AthenaEndpointFromUrl", stringArray[i]);
                }
                if (null != object[1]) {
                    treeMap.put("CatalogFromEndpoint", object[1]);
                }
            }
            if (2 > ((String[])(object = stringArray[i].split(VALUE_DELIMITER, SPLIT_LIMIT))).length) {
                treeMap.put(object[0], "");
                continue;
            }
            treeMap.put(object[0], object[1]);
            if (!object[0].equalsIgnoreCase("EndpointOverride")) continue;
            String[] stringArray2 = AJCoreUtils.parseRegionAndCatalogFromEndoint(object[1]);
            if (null != stringArray2[0]) {
                treeMap.put("RegionFromEndpointOverride", stringArray2[0]);
            }
            if (null == stringArray2[1]) continue;
            treeMap.put("CatalogFromEndpointOverride", stringArray2[1]);
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (treeMap.containsKey(object)) continue;
            treeMap.put(object, properties.getProperty((String)object));
        }
        properties.clear();
        properties.putAll((Map<?, ?>)treeMap);
        return true;
    }

    public static String[] parseRegionAndCatalogFromEndoint(String string) {
        String[] stringArray = string.split(REGION_DELIMITER);
        String[] stringArray2 = new String[]{null, null};
        if (4 == stringArray.length && stringArray[2].equals(ATHENA_ENDPOINT_END) && (stringArray[3].equals(ATHENA_ENDPOINT_PORT) || stringArray[3].startsWith(ATHENA_ENDPOINT_PORT_WITH_BACKSLASH))) {
            stringArray2[0] = stringArray[1];
            String[] stringArray3 = stringArray[3].split(BACKSLASH_DELIMITER);
            if (2 == stringArray3.length) {
                stringArray2[1] = stringArray3[1];
            }
        } else if (5 == stringArray.length && stringArray[2].equals(ATHENA_ENDPOINT_END) && (stringArray[4].equals(ATHENA_CHINA_ENDPOINT_PORT) || stringArray[4].startsWith(ATHENA_CHINA_ENDPOINT_PORT_WITH_BACKSLASH))) {
            stringArray2[0] = stringArray[1];
            String[] stringArray4 = stringArray[4].split(BACKSLASH_DELIMITER);
            if (2 == stringArray4.length) {
                stringArray2[1] = stringArray4[1];
            }
        } else {
            for (int i = 1; i < stringArray.length - 1; ++i) {
                if (!stringArray[i].equals(ATHENA_ENDPOINT_VPC) || !stringArray[i + 1].equals(ATHENA_ENDPOINT_END)) continue;
                stringArray2[0] = stringArray[i - 1];
                String[] stringArray5 = stringArray[stringArray.length - 1].split(BACKSLASH_DELIMITER);
                if (2 != stringArray5.length) continue;
                stringArray2[1] = stringArray5[1];
            }
        }
        return stringArray2;
    }
}

