/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.core.KeyPair;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class SPKAC
implements ASN1Object,
Externalizable {
    private PublicKey pubKey;
    private String challenge;
    private PrivateKey privKey;
    private ASN1Sequence contents;
    private transient RandomBitsSource rbs;

    public SPKAC() {
    }

    public SPKAC(KeyPair kp) {
        this(kp, RandomBitsSource.getDefault());
    }

    public SPKAC(KeyPair kp, RandomBitsSource rbs) {
        this("", kp, rbs);
    }

    public SPKAC(String challenge, KeyPair kp) {
        this(challenge, kp, RandomBitsSource.getDefault());
    }

    public SPKAC(String challenge, KeyPair kp, RandomBitsSource rbs) {
        this.pubKey = kp.getPublic();
        this.privKey = kp.getPrivate();
        this.challenge = challenge;
    }

    public SPKAC(String challenge) {
        this.challenge = challenge;
    }

    public SPKAC(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public SPKAC(String challenge, InputStream is) throws IOException {
        this(challenge);
        this.input(is);
    }

    public SPKAC(String challenge, String data) throws IOException {
        this(challenge);
        this.input(data);
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence pkac = new ASN1Sequence();
        pkac.addElement((ASN1Object)CryptoUtils.subjectPublicKeyInfo((PublicKey)this.pubKey));
        pkac.addElement((ASN1Object)new ASN1String(this.challenge, 22));
        try {
            this.contents = CryptoUtils.signASN1((ASN1Object)pkac, (PrivateKey)this.privKey, (RandomBitsSource)this.rbs);
        }
        catch (SignatureException ex) {
            throw new StreamableOutputException(ex.toString());
        }
        return this.contents;
    }

    public void input(InputStream is) throws IOException {
        this.input(new ASN1Sequence(is));
    }

    void input(ASN1Sequence s) throws IOException {
        this.contents = s;
        String c = null;
        try {
            ASN1Sequence pkac = (ASN1Sequence)s.elementAt(0);
            this.pubKey = CryptoUtils.inputSPKI((ASN1Sequence)((ASN1Sequence)pkac.elementAt(0)));
            c = ((ASN1String)pkac.elementAt(1)).getValue();
        }
        catch (ClassCastException e) {
            throw new ASN1FormatException(e.toString());
        }
        if (this.challenge == null) {
            this.challenge = c;
        } else if (!this.challenge.equals(c)) {
            throw new IOException("Challenge does not equal the expected value");
        }
        if (!CryptoUtils.verifySignedASN1((ASN1Sequence)s, (PublicKey)this.pubKey)) {
            throw new IOException("Invalid signature");
        }
    }

    public void input(String data) throws IOException {
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(Utils.fromBase64((String)data));
        this.input((InputStream)is);
    }

    public int length() {
        return this.outputASN1().length();
    }

    public String toBase64() throws IOException {
        FixedByteArrayOutputStream os = new FixedByteArrayOutputStream(this.length());
        this.output((OutputStream)os);
        return Utils.toBase64((byte[])os.getBytes());
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

