/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbcext.HanaXAResource;
import com.sap.db.jdbcext.PooledConnectionSAP;
import com.sap.db.jdbcext.XAResourceSAP;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

@ThreadSafe
public abstract class XAConnectionSAP
extends PooledConnectionSAP
implements XAConnection {
    private final XAResourceSAP _xaResource;

    protected XAConnectionSAP(Connection connection) {
        super(connection);
        this._xaResource = new HanaXAResource(connection);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this._xaResource;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        Connection connection = super.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public void reinitialize(ConnectionSapDB connection) throws SQLException {
        connection.reinitialize(true, false);
    }
}

