/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.ui;

import com.dbeaver.lm.app.LMAppUtils;
import com.dbeaver.lm.embedded.LicenseServiceEmbedded;
import com.dbeaver.lm.internal.ui.LMUIActivator;
import com.dbeaver.lm.internal.ui.LMUIMessages;
import com.dbeaver.lm.validate.LicenseRequest;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class LicenseTrialDialog
extends BaseDialog {
    private Text emailText;
    private Text firstNameText;
    private Text lastNameText;
    private Text companyText;
    private Button newslettersInterestedButton;
    private ProgressMonitorPart monitorPart;

    public LicenseTrialDialog(Shell parentShell) {
        super(parentShell, LMUIMessages.dialog_trial_license_title, null);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Composite createDialogArea(Composite parent) {
        DBPPreferenceStore prefStore = LMUIActivator.getDefault().getPreferences();
        Composite composite = super.createDialogArea(parent);
        Group infoGroup = UIUtils.createControlGroup((Composite)composite, (String)LMUIMessages.dialog_trial_license_info, (int)2, (int)1808, (int)0);
        this.emailText = UIUtils.createLabelText((Composite)infoGroup, (String)LMUIMessages.dialog_trial_license_info_email, (String)CommonUtils.toString((Object)prefStore.getString("trialEmail")));
        this.firstNameText = UIUtils.createLabelText((Composite)infoGroup, (String)LMUIMessages.dialog_trial_license_info_first_name, (String)CommonUtils.toString((Object)prefStore.getString("trialFirstName")));
        this.lastNameText = UIUtils.createLabelText((Composite)infoGroup, (String)LMUIMessages.dialog_trial_license_info_last_name, (String)CommonUtils.toString((Object)prefStore.getString("trialLastName")));
        this.companyText = UIUtils.createLabelText((Composite)infoGroup, (String)LMUIMessages.dialog_trial_license_info_company_name, (String)CommonUtils.toString((Object)prefStore.getString("trialCompany")));
        this.newslettersInterestedButton = UIUtils.createCheckbox((Composite)composite, (String)LMUIMessages.dialog_trial_license_subscribe_to_newsletters, (boolean)prefStore.getBoolean("newslettersInterested"));
        Link link = new Link(composite, 64);
        link.setText(LMUIMessages.dialog_trial_license_hint);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)"https://dbeaver.com/trial");
            }
        });
        this.monitorPart = new ProgressMonitorPart(composite, null, true){

            public void setCanceled(boolean b) {
                super.setCanceled(b);
                if (b) {
                    LicenseTrialDialog.this.cancelCurrentOperation();
                }
            }
        };
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        gd.verticalIndent = 0;
        this.monitorPart.setLayoutData((Object)gd);
        this.monitorPart.setVisible(false);
        return parent;
    }

    private void run(@NotNull DBRRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.monitorPart != null) {
            this.monitorPart.setVisible(true);
            this.monitorPart.layout();
            this.monitorPart.attachToCancelComponent(null);
        }
        ControlEnableState state = ControlEnableState.disable((Control)this.getContents(), List.of(this.monitorPart));
        try {
            ModalContext.run(monitor -> runnable.run((DBRProgressMonitor)new DefaultProgressMonitor(monitor)), (boolean)true, (IProgressMonitor)this.monitorPart, (Display)this.getShell().getDisplay());
        }
        finally {
            state.restore();
            if (this.monitorPart != null) {
                this.monitorPart.done();
                this.monitorPart.setVisible(false);
            }
        }
    }

    private void cancelCurrentOperation() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, LMUIMessages.dialog_trial_license_button_request, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && !this.requestLicense()) {
            return;
        }
        super.buttonPressed(buttonId);
    }

    private boolean requestLicense() {
        try {
            DBPPreferenceStore prefStore = LMUIActivator.getDefault().getPreferences();
            String email = this.validateFieldPresence(LMUIMessages.dialog_trial_license_info_email, ".+@.+\\..+", this.emailText);
            String firstName = this.validateFieldPresence(LMUIMessages.dialog_trial_license_info_first_name, "\\w+", this.firstNameText);
            String lastName = this.validateFieldPresence(LMUIMessages.dialog_trial_license_info_last_name, "\\w+", this.lastNameText);
            String company = this.companyText.getText();
            boolean newslettersInterested = this.newslettersInterestedButton.getSelection();
            prefStore.setValue("trialEmail", email);
            prefStore.setValue("trialFirstName", firstName);
            prefStore.setValue("trialLastName", lastName);
            prefStore.setValue("trialCompany", company);
            prefStore.setValue("newslettersInterested", newslettersInterested);
            LicenseRequest request = new LicenseRequest(email, firstName, lastName, company, newslettersInterested);
            LicenseServiceEmbedded service = (LicenseServiceEmbedded)LMAppUtils.getLicenseService();
            IStatus[] result = new IStatus[1];
            this.run(monitor -> {
                IStatus iStatus = service.requestTrialLicense(monitor, request);
            });
            IStatus trial = result[0];
            if (!trial.isOK()) {
                DBWorkbench.getPlatformUI().showError(LMUIMessages.dialog_trial_license_error_request_title, LMUIMessages.dialog_trial_license_error_request_message, trial);
            }
            return trial.isOK();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showMessageBox(LMUIMessages.dialog_trial_license_error_form_title, NLS.bind((String)LMUIMessages.dialog_trial_license_error_form_message, (Object)e.getMessage()), true);
            return false;
        }
    }

    private String validateFieldPresence(String fieldName, String pattern, Text text) throws DBException {
        String fieldValue = text.getText().trim();
        if (fieldValue.isEmpty()) {
            text.setFocus();
            throw new DBException(NLS.bind((String)LMUIMessages.dialog_trial_license_error_form_empty_value, (Object)fieldName));
        }
        if (!Pattern.compile(pattern, 256).matcher(fieldValue).matches()) {
            text.setFocus();
            throw new DBException(NLS.bind((String)LMUIMessages.dialog_trial_license_error_form_invalid_value, (Object)fieldName));
        }
        return fieldValue;
    }
}

