/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jgss;

import com.intersys.jgss.GSSCallbackHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class Configure {
    public static void main(String[] args) {
        String home = System.getProperty("java.home");
        String sep = System.getProperty("file.separator");
        String filename = null;
        int nx = 0;
        try {
            Class<?> vclass;
            PrintStream ps;
            String line;
            filename = home + sep + "lib" + sep + "security" + sep + "java.security";
            File file = new File(filename);
            if (!file.exists()) {
                System.out.println(filename + " does not exist.  Exiting.");
                System.exit(1);
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            boolean done = false;
            boolean test = false;
            while (!done && (line = br.readLine()) != null) {
                if (line.length() < 63 || !line.substring(0, 17).equals("login.config.url.")) continue;
                if (line.substring(line.indexOf("=")).equals("=file:${java.home}/lib/security/iscLogin.conf")) {
                    done = true;
                    test = true;
                    System.out.println(filename + " is properly configured.");
                    continue;
                }
                int n = Integer.parseInt(line.substring(17, line.indexOf("=")));
                if (n <= nx) continue;
                nx = n;
            }
            br.close();
            if (!done) {
                System.out.println("Configuring " + filename + ".");
                ps = new PrintStream(new FileOutputStream(file, true));
                ps.println("");
                ps.println("#");
                ps.println("# InterSystems login configuration file");
                ps.println("#");
                ps.println("login.config.url." + String.valueOf(nx + 1) + "=file:${java.home}/lib/security/iscLogin.conf");
                ps.close();
            }
            boolean ibm = false;
            try {
                vclass = Class.forName("com.sun.security.auth.module.Krb5LoginModule");
            }
            catch (ClassNotFoundException e) {
                try {
                    vclass = Class.forName("com.ibm.security.auth.module.Krb5LoginModule");
                    ibm = true;
                }
                catch (ClassNotFoundException ee) {
                    System.out.println("Can not resolve class Krb5LoginModule.  Exiting.");
                    System.exit(1);
                }
            }
            filename = home + sep + "lib" + sep + "security" + sep + "iscLogin.conf";
            file = new File(filename);
            if (file.exists()) {
                System.out.println("Updating " + filename + ".");
                file.delete();
            } else {
                System.out.println("Creating " + filename + ".");
            }
            ps = new PrintStream(new FileOutputStream(file));
            ps.println("/**");
            ps.println(" * InterSystems login configuration file");
            ps.println(" */");
            ps.println("");
            ps.println("com.sun.security.jgss.initiate {");
            if (ibm) {
                ps.println("  com.ibm.security.auth.module.Krb5LoginModule required useDefaultCcache=false;");
            } else {
                ps.println("  com.sun.security.auth.module.Krb5LoginModule required useTicketCache=true;");
            }
            ps.println("};");
            ps.println("");
            ps.println("iscTest {");
            if (ibm) {
                ps.println("  com.ibm.security.auth.module.Krb5LoginModule required useDefaultCcache=false;");
            } else {
                ps.println("  com.sun.security.auth.module.Krb5LoginModule required useTicketCache=false;");
            }
            ps.println("};");
            ps.close();
            filename = System.getProperty("java.security.krb5.conf");
            if (filename == null) {
                filename = home + sep + "lib" + sep + "security" + sep + "krb5.conf";
            }
            br = new BufferedReader(new InputStreamReader(System.in));
            file = new File(filename);
            done = false;
            if (file.exists()) {
                done = true;
                System.out.print(filename + " exists.\nReplace it?  [No]: ");
                line = br.readLine();
                if (line.length() > 0 && line.substring(0, 1).toUpperCase().equals("Y")) {
                    System.out.println("Replacing " + filename + ".");
                    file.renameTo(new File(filename + ".old"));
                    file = new File(filename);
                    done = false;
                }
            } else {
                File file2;
                String filename2 = null;
                String template = null;
                line = System.getProperty("os.name");
                if (line.startsWith("Windows")) {
                    filename2 = "c:\\winnt\\krb5.ini";
                } else if (line.equals("SunOS")) {
                    filename2 = "/etc/krb5/krb5.conf";
                    template = "___default_realm___";
                } else if (line.equals("Linux")) {
                    filename2 = "/etc/krb5.conf";
                    template = "EXAMPLE.COM";
                }
                if (filename2 != null && (file2 = new File(filename2)).exists()) {
                    done = true;
                    if (template != null) {
                        BufferedReader br2 = new BufferedReader(new FileReader(file2));
                        while (done && (line = br2.readLine()) != null) {
                            if (line.indexOf("default_realm") < 0 || line.indexOf(template) < 0) continue;
                            done = false;
                        }
                    }
                    if (done) {
                        System.out.print(filename2 + " exists.\n" + "Create " + filename + " anyway?  [No]: ");
                        line = br.readLine();
                        if (line.length() > 0 && line.substring(0, 1).toUpperCase().equals("Y")) {
                            done = false;
                        }
                    }
                }
                if (!done) {
                    System.out.println("Creating " + filename + ".");
                }
            }
            if (!done) {
                ps = new PrintStream(new FileOutputStream(file));
                String domain = InetAddress.getLocalHost().getCanonicalHostName();
                domain = domain.substring(domain.indexOf(".") + 1);
                String realm = domain.toUpperCase();
                System.out.print("Kerberos realm [" + realm + "]: ");
                line = br.readLine();
                if (line.length() > 0) {
                    realm = line.toUpperCase();
                }
                ps.println("[libdefaults]");
                ps.println("    default_realm = " + realm);
                if (ibm) {
                    System.out.print("Are Windows Domain Controllers being used as KDCs? [No]: ");
                    line = br.readLine();
                    if (line.length() > 0 && line.substring(0, 1).toUpperCase().equals("Y")) {
                        ps.println("    default_tkt_enctypes = des-cbc-crc");
                        ps.println("    default_tgs_enctypes = des-cbc-crc");
                    }
                }
                ps.println("");
                ps.println("[realms]");
                ps.println("    " + realm + " = {");
                done = false;
                while (!done) {
                    System.out.print("Primary KDC: ");
                    line = br.readLine();
                    if (line.length() <= 0) continue;
                    try {
                        line = InetAddress.getByName(line).getCanonicalHostName();
                        ps.println("        kdc = " + line);
                        ps.println("        admin_server = " + line);
                        done = true;
                    }
                    catch (UnknownHostException e) {
                        System.out.println("Unknown host.");
                    }
                }
                done = false;
                while (!done) {
                    System.out.print("Additional KDC (<CR> when done): ");
                    line = br.readLine();
                    if (line.length() > 0) {
                        try {
                            line = InetAddress.getByName(line).getCanonicalHostName();
                            ps.println("        kdc = " + line);
                        }
                        catch (UnknownHostException e) {
                            System.out.println("Unknown host.");
                        }
                        continue;
                    }
                    done = true;
                }
                ps.println("    }");
                if (!realm.equals(domain.toUpperCase())) {
                    ps.println("");
                    ps.println("[domain_realm]");
                    ps.println("    ." + domain + " = " + realm);
                    ps.println("    " + domain + " = " + realm);
                }
                ps.close();
            }
            if (!test) {
                System.out.println("Re-run this class to test configuration.");
                System.exit(0);
            }
            System.out.println("Testing configuration...");
            LoginContext lc = null;
            try {
                lc = new LoginContext("iscTest", new GSSCallbackHandler());
                lc.login();
                System.out.println("Login test succeeded.");
            }
            catch (LoginException e) {
                System.out.println(e.toString());
                System.out.println("Login test failed.");
                System.exit(1);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        catch (SecurityException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        System.out.println("Done!");
    }
}

