/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc.preparser2;

import com.intersys.jdbc.preparser2.CacheSqlPreParserTokenManager;
import com.intersys.util.ListUtil;

public class Token {
    private static final int POOL_SIZE = 32;
    private static boolean expandable = false;
    protected String buffer;
    private int bufLen;
    public int kind;
    public int beginLine;
    public int beginColumn;
    public int endLine;
    public int endColumn;
    public String image;
    public Token next;
    public Token specialToken;
    private static int counter = 0;
    private static Token[] tBuffer = null;
    public int format = 0;
    public static final int CAST_CHAR32 = 1;
    public static final int CAST_CHAR128 = 2;
    public static final int CAST_CHAR512 = 3;
    public static final int CAST_CHAR = 4;
    public static final int CAST_INT = 10;
    public static final int CAST_NUM = 11;
    public boolean isParam = false;
    public char paramType = '\u0000';

    public Token() {
        this.buffer = CacheSqlPreParserTokenManager.input_stream.buffer;
        this.bufLen = this.buffer.length();
    }

    public Token(String input) {
        this.buffer = input;
        this.bufLen = this.buffer.length();
    }

    public int getLength() {
        return this.endColumn - this.beginColumn;
    }

    public String toString() {
        if (this.image == null) {
            this.image = this.beginColumn >= this.bufLen ? "<EOS>" : (this.endColumn >= this.bufLen ? this.buffer.substring(this.beginColumn, this.bufLen - 1) : this.buffer.substring(this.beginColumn, this.endColumn + 1));
        }
        return this.image;
    }

    public String toCanonizedFloatingPointString() {
        return ListUtil.canonizeFloatingPointString(this.buffer.substring(this.beginColumn, this.endColumn + 1));
    }

    public String toStringUnQuoted() {
        char first = this.buffer.charAt(this.beginColumn);
        if (first == '\'' || first == '\"') {
            return this.buffer.substring(this.beginColumn + 1, this.endColumn);
        }
        return this.buffer.substring(this.beginColumn, this.endColumn + 1);
    }

    public String getTDSValue() {
        int start = this.buffer.indexOf(123, this.beginColumn);
        if (start < 0) {
            return null;
        }
        if ((start = this.buffer.indexOf(39, start)) < 0) {
            return null;
        }
        int end = this.buffer.indexOf(39, start + 1);
        while (end > 0 && end + 1 < this.endColumn && this.buffer.charAt(end + 1) == '\'') {
            end = this.buffer.indexOf(39, end + 2);
        }
        if (end < 0) {
            return null;
        }
        return this.buffer.substring(start + 1, end);
    }

    public static final Token newToken(int ofKind) {
        switch (ofKind) {
            default: 
        }
        Token t = Token.getToken();
        t.buffer = CacheSqlPreParserTokenManager.input_stream.buffer;
        t.bufLen = t.buffer.length();
        return t;
    }

    public static final Token newToken(int ofKind, String input) {
        switch (ofKind) {
            default: 
        }
        Token t = Token.getToken();
        t.buffer = input;
        t.bufLen = t.buffer.length();
        return t;
    }

    public void prepend(Token prefix) {
        this.beginColumn = prefix.beginColumn;
    }

    public static void setExpandable(boolean res) {
        expandable = res;
    }

    private static Token getToken() {
        if (tBuffer == null) {
            tBuffer = new Token[32];
            for (int i = 0; i < tBuffer.length; ++i) {
                Token.tBuffer[i] = new Token();
            }
            counter = 0;
        }
        if (expandable) {
            if (counter >= tBuffer.length) {
                Token.resizePool();
            }
            if (tBuffer[counter] == null) {
                Token.tBuffer[Token.counter] = new Token();
            }
        } else if (counter >= tBuffer.length) {
            counter = 0;
        }
        Token.tBuffer[Token.counter].next = null;
        Token.tBuffer[Token.counter].isParam = false;
        Token.tBuffer[Token.counter].format = 0;
        Token.tBuffer[Token.counter].paramType = '\u0000';
        return tBuffer[counter++];
    }

    private static void resizePool() {
        int poolSize = tBuffer.length * 2;
        Token[] tb = new Token[poolSize];
        System.arraycopy(tBuffer, 0, tb, 0, tBuffer.length);
        tBuffer = tb;
    }

    public static void reinit() {
        counter = 0;
    }

    public static int getPoolSize() {
        return tBuffer.length;
    }
}

