/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc.preparser;

import com.intersys.jdbc.CacheListBuilder;
import com.intersys.jdbc.CacheParameter;
import com.intersys.jdbc.ExecParameter;
import com.intersys.jdbc.PreparserInterface;
import com.intersys.jdbc.preparser.PreParseResult;
import com.intersys.jdbc.preparser.PreParser;
import com.intersys.jdbc.preparser2.StatementTypes;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Parser
extends PreparserInterface {
    private PreParser m_preparser = null;
    private PreParseResult m_sqlResult = null;
    ArrayList<CacheParameter> m_Parameters = new ArrayList();
    private String m_sql;

    public Parser(String sql, boolean delIds, int addRID) {
        this.m_preparser = new PreParser(delIds, addRID);
        this.m_sql = sql;
    }

    @Override
    public void preparse() throws SQLException {
        try {
            this.m_sqlResult = this.m_preparser.PreParse(this.m_sql, this.m_Parameters);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getStatementType() {
        return this.m_sqlResult.p_eStmtType;
    }

    @Override
    public String getOptionName() {
        try {
            throw new Exception("getOptionName Not Supported");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getOptionValue() {
        try {
            throw new Exception("getOptionValue Not Supported");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getParametersCount() {
        return this.m_Parameters.size() - this.m_preparser.m_ExecParamCount;
    }

    @Override
    public String getPreparsedSQL() {
        return this.m_sqlResult.sResult;
    }

    @Override
    public List getParameters() {
        if (0 == this.m_Parameters.size()) {
            return null;
        }
        ArrayList<StatementTypes.Parameter> parameters = new ArrayList<StatementTypes.Parameter>();
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            CacheParameter cp = this.m_Parameters.get(i);
            if (cp.m_ExecuteParam) continue;
            StatementTypes.Parameter p = new StatementTypes.Parameter(cp.GetParamType(), cp.GetValue());
            parameters.add(p);
        }
        return parameters;
    }

    @Override
    public CacheListBuilder getParamInfo() {
        return this.m_preparser.ParamInfoGet().trim();
    }

    @Override
    public ArrayList<ExecParameter> getExecParams() {
        if (0 == this.m_Parameters.size()) {
            return null;
        }
        ArrayList<ExecParameter> eXparameters = new ArrayList<ExecParameter>();
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            CacheParameter cp = this.m_Parameters.get(i);
            if (!cp.m_ExecuteParam) continue;
            ExecParameter p = new ExecParameter();
            p.constantType = cp.m_ExecConstantType;
            int iMode = cp.GetMode();
            if (1 == iMode || 7 == iMode) {
                p.ioType = 1;
            } else if (2 == iMode || 4 == iMode) {
                p.ioType = 2;
            }
            p.mode = iMode;
            p.name = cp.GetName();
            if (6 == iMode) {
                p.isDefault = true;
            }
            p.name = cp.GetName();
            p.bound = cp.GetBound();
            eXparameters.add(p);
        }
        if (eXparameters.size() > 0) {
            return eXparameters;
        }
        return null;
    }

    @Override
    public StatementTypes.Parameter getParameter(int i) {
        CacheParameter cp = this.m_Parameters.get(i);
        StatementTypes.Parameter par = new StatementTypes.Parameter(cp.GetParamType(), cp.GetValue());
        return par;
    }
}

