/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.RealStream;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class CacheWriter
extends Writer {
    private RealStream stream;
    private char[] charArray = null;
    private long position;

    CacheWriter(RealStream s, long pos) {
        this.stream = s;
        this.position = pos;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.stream.closed) {
            throw new IOException("This stream object is closed.");
        }
        if (this.charArray == null) {
            this.charArray = new char[len];
            System.arraycopy(cbuf, off, this.charArray, 0, len);
        } else {
            char[] newCharArray = new char[len + this.charArray.length];
            System.arraycopy(this.charArray, 0, newCharArray, 0, this.charArray.length);
            System.arraycopy(cbuf, off, newCharArray, this.charArray.length, len);
            this.charArray = newCharArray;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            byte[] byteArray = new String(this.charArray).getBytes();
            this.stream.sendBytes(this.position, byteArray, 0, byteArray.length);
            this.stream.getStreamSize();
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

