/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBlob;
import com.intersys.jdbc.CacheClob;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.FakeStream;
import com.intersys.jdbc.RealStream;
import com.intersys.jdbc.Stream;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class CacheReader
extends Reader {
    Stream stream;
    private boolean closed = false;
    private boolean ready = false;

    CacheReader(CacheConnection conn, byte[] oref, int scn, int sqlt, int max) throws SQLException {
        this.init(conn, oref, scn, sqlt, max);
    }

    CacheReader(CacheConnection conn, String oid, int scn, int sqlt, int max) throws SQLException {
        this.stream = new RealStream(conn, oid, null, scn, 4, sqlt, max);
        ((RealStream)this.stream).getSize();
        if (this.stream.size > 0) {
            this.ready = true;
        }
    }

    CacheReader(Stream s) throws SQLException {
        this.stream = s;
        if (this.stream.size > 0) {
            this.ready = true;
        }
        if (this.stream.size > 0 && this.stream.size != this.stream.available) {
            ((RealStream)this.stream).getStreamSize();
        }
    }

    CacheReader(CacheConnection conn, byte[] h, int scn) throws SQLException {
        this.init(conn, h, scn, -1, 0);
    }

    CacheReader(String s) throws SQLException {
        this.stream = new FakeStream(s.toCharArray(), 4, -1, 0);
        this.ready = true;
    }

    private void init(CacheConnection conn, byte[] oref, int scn, int sqlType, int max) throws SQLException {
        this.stream = new RealStream(conn, null, oref, scn, 4, sqlType, max);
        ((RealStream)this.stream).getStreamSize();
        if (this.stream.size > 0) {
            this.ready = true;
        }
    }

    @Override
    public boolean ready() throws IOException {
        if (this.closed) {
            throw new IOException("This reader object has been closed.");
        }
        return this.ready;
    }

    @Override
    public int read() throws IOException {
        char[] c = new char[1];
        if (this.read(c, 0, 1) <= 0) {
            return -1;
        }
        return c[0];
    }

    @Override
    public synchronized int read(char[] c, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("This reader object has been closed.");
        }
        if (!this.ready) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        try {
            int l;
            int ret = 0;
            do {
                if ((l = this.stream.fetchStream(c, 4, off + ret, len - ret)) >= 0) continue;
                if (ret == 0) {
                    return l;
                }
                break;
            } while ((ret += l) < len);
            return ret;
        }
        catch (Exception e) {
            throw new IOException("Unable to read stream data.");
        }
    }

    boolean isNull() {
        return this.stream.isNull();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.ready = false;
        if (!(this.stream instanceof CacheBlob) && !(this.stream instanceof CacheClob)) {
            this.stream.close();
        } else {
            ((RealStream)this.stream).releaseReadLock();
        }
    }

    final String toUnicodeString() throws SQLException {
        try {
            if (this.stream.size == 0) {
                return "";
            }
            char[] cb = new char[this.stream.size];
            int i = this.read(cb);
            return new String(cb, 0, i);
        }
        catch (Exception e) {
            throw new SQLException("Error read stream data " + e.getMessage(), "S1000");
        }
    }
}

