/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBufferWrite;
import com.intersys.jdbc.CacheCallableStatement;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheListBuilder;
import com.intersys.jdbc.CacheParameterMetaData;
import com.intersys.jdbc.CacheResultSetMetaData;
import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.CacheStruct;
import com.intersys.jdbc.ExecParameter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public class CachePreparedStatement
extends CacheStatement
implements PreparedStatement {
    CachePreparedStatement(CacheConnection conn, int rst, int rsc, String sql, String agk) throws SQLException {
        super(conn, rst, rsc, agk);
        this.prepare(sql);
    }

    CachePreparedStatement(CacheConnection conn, int rst, String sql, int stmtType, long paramCount) throws SQLException {
        super(conn, rst, 1007, null);
        this.prepare(sql, stmtType, paramCount);
    }

    CachePreparedStatement(CacheConnection conn) throws SQLException {
        super(conn, 1003, 1007, null);
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.genericExecuteCalled = false;
        this.Query();
        if (this.multipleResultSets) {
            this.columnInfo(this.input.wire);
        }
        this.updateCnt = -1;
        return this.myResultSet;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("executeQuery(String sql) form not allowed.", "S1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void Query() throws SQLException {
        this.fetchDone = false;
        if (this.statementType != 1 && this.statementType != 12 && this.statementType != 10 && this.statementType != 14) {
            throw new SQLException("executeQuery called with a non-query.", "24000", 24000);
        }
        if (this.execParams != null) {
            this.bindExecParameters();
        }
        this.validateParameters();
        this.createResultSet();
        if (this instanceof CacheCallableStatement || this.statementType == 12) {
            this.storedProcedureQuery();
            return;
        }
        if (this.statementType == 14) {
            this.executeMultipleResultSets(false);
            return;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            if (this.resultSetType == 1004) {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.EXECUTE_STATIC_CURSOR);
            } else {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARED_QUERY_EXECUTE);
            }
            this.writeParameters(this.output.wire);
            this.output.wire.set(this.queryTimeout);
            this.output.wire.set(this.maxRows);
            this.output.send(this.connection.messageCount.getCount());
            this.handleError504(this.input.readMessage(this, 2, 504));
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        if (this.multipleResultSets) {
            throw new SQLException("execute() must be used to retrieve multiple result sets.", "08003");
        }
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.genericExecuteCalled = false;
        this.Update();
        if (this.parameterSets == 0) {
            this.updateCnt = this.input.wire.getInt();
        }
        if (this.statementType == 15) {
            this.connection.resetConnection(false);
        }
        return this.updateCnt;
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        throw new SQLException("executeUpdate(String sql) form not allowed.", "S1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void Update() throws SQLException {
        if (this.statementType == 1 || this.statementType == 12) {
            throw new SQLException("executeUpdate called with a query.", "24000", 24000);
        }
        if (this.execParams != null) {
            this.bindExecParameters();
        }
        this.validateParameters();
        if (this.statementType == 14) {
            this.executeMultipleResultSets(false);
            return;
        }
        if (this instanceof CacheCallableStatement || this.statementType == 13 || this.statementType == 11) {
            this.storedProcedureUpdate();
            return;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            int messageCount2;
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARED_UPDATE_EXECUTE);
            this.output.wire.set(this.autoGeneratedKeyColumn);
            if (this.connection.protocolVersion >= 42) {
                this.output.wire.set(0);
            }
            if ((messageCount2 = this.writePSUpdateParameters(this.output.wire)) != -1) {
                this.output.send(messageCount2);
            } else {
                this.output.send(this.connection.messageCount.getCount());
            }
            if (this.statementType == 15) {
                this.connection.cachedPrepares.clear();
            }
            if (this.input.readMessage(this, 0, 504) == 404) {
                this.update404();
                return;
            }
            this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
        }
    }

    synchronized int writePSUpdateParameters(CacheBufferWrite wire) throws SQLException {
        int sets = this.parameterSets;
        int messageCount = -1;
        if (this.parameterSets == 0) {
            sets = 1;
        }
        wire.set(sets);
        wire.set(this.parameters.size());
        for (int j = 0; j < sets; ++j) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                CacheStatement.Parameter par = (CacheStatement.Parameter)this.parameters.get(i);
                this.checkDataType(par.type, par.values.get(0));
                if (par.mode == 5) {
                    wire.setParameter(par.values.get(0), par.type);
                    continue;
                }
                if (par.mode == 6) {
                    wire.setUndefined();
                    continue;
                }
                if (par.whatever != null && j < par.whatever.size() && par.whatever.get(j) != null) {
                    wire.setParameter(par.values.get(j), par.whatever.get(j), par.type);
                    continue;
                }
                if (par.values.get(j) instanceof CacheStatement.StreamWrapper) {
                    wire.setParameter(this.sendStream(i, (CacheStatement.StreamWrapper)par.values.get(j)), par.type);
                    continue;
                }
                if (!this.hasStreamParameters) {
                    messageCount = wire.setParameter(this.output.outputStream, this.connection, messageCount, par.values.get(j), par.type);
                    continue;
                }
                wire.setParameter(par.values.get(j), par.type);
            }
        }
        return messageCount;
    }

    private void checkDataType(int iServerType, Object value) throws SQLException {
        if (null != value) {
            switch (iServerType) {
                case -7: 
                case -6: 
                case -5: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 12: 
                case 16: {
                    if (!(value instanceof byte[])) break;
                    throw new SQLException("Unsupported type conversion of Byte Array ", "S1000");
                }
                case -4: 
                case -3: 
                case -2: 
                case 2003: 
                case 2004: 
                case 2005: {
                    if (!(value instanceof Byte) && !(value instanceof Short) && !(value instanceof Float) && !(value instanceof Long) && !(value instanceof Integer) && !(value instanceof Date) && !(value instanceof Time) && !(value instanceof Timestamp) && !(value instanceof Double)) break;
                    throw new SQLException("Unsupported type conversion", "S1000");
                }
                case 91: 
                case 92: 
                case 93: 
                case 1091: 
                case 1092: 
                case 1093: {
                    if (value instanceof BigDecimal) {
                        throw new SQLException("Unsupported type conversion for  BigDecimal", "S1000");
                    }
                    if (value instanceof byte[]) {
                        throw new SQLException("Unsupported type conversion of Byte Array ", "S1000");
                    }
                    if (!(value instanceof Byte) && !(value instanceof Short) && !(value instanceof Float) && !(value instanceof Long) && !(value instanceof Integer) && !(value instanceof Double)) break;
                    throw new SQLException("Unsupported type conversion", "S1000");
                }
            }
        }
    }

    @Override
    public void setNull(int i, int jdbcType) throws SQLException {
        this.setGeneric(i, null);
    }

    @Override
    public void setBoolean(int i, boolean x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setByte(int i, byte x) throws SQLException {
        this.setGeneric(i, new Short(x));
    }

    @Override
    public void setShort(int i, short x) throws SQLException {
        this.setGeneric(i, new Short(x));
    }

    @Override
    public void setInt(int i, int x) throws SQLException {
        this.setGeneric(i, new Integer(x));
    }

    @Override
    public void setLong(int i, long x) throws SQLException {
        this.setGeneric(i, new Long(x));
    }

    @Override
    public void setFloat(int i, float x) throws SQLException {
        this.setGeneric(i, new Float(x));
    }

    @Override
    public void setDouble(int i, double x) throws SQLException {
        this.setGeneric(i, new Double(x));
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setString(int i, String x) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (x.length() > 10000) {
            this.setCharacterStream(i, (Reader)new StringReader(x), x.length());
        } else {
            this.setGeneric(i, x);
        }
    }

    @Override
    public void setBytes(int i, byte[] x) throws SQLException {
        if (this.getParameterTypeAbsolute(i) == -1) {
            throw new SQLException("Unsupported type conversion: byte[] to java.sql.Types.LONGVARCHAR.", "S1000");
        }
        if (this.getParameterTypeAbsolute(i) == -4) {
            if (x == null) {
                this.setGeneric(i, null);
                return;
            }
            if (x.length > 10000) {
                this.setBinaryStream(i, (InputStream)new ByteArrayInputStream(x), x.length);
                return;
            }
            this.setGeneric(i, x);
            return;
        }
        this.setGeneric(i, x);
    }

    @Override
    public void setDate(int i, Date x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setTime(int i, Time x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setTimestamp(int i, Timestamp x) throws SQLException {
        this.setGeneric(i, x);
    }

    @Override
    public void setAsciiStream(int i, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setGeneric(i, new CacheStatement.StreamWrapper(x, 0, length));
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int i, InputStream x, int length) throws SQLException {
        throw new SQLException("This api is no longer supported.", "S1000");
    }

    @Override
    public void setBinaryStream(int i, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getParameterTypeAbsolute(i) == -1) {
            throw new SQLException("Unsupported type conversion: (binary) InputStream to java.sql.Types.LONGVARCHAR.", "S1000");
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setGeneric(i, new CacheStatement.StreamWrapper(x, 1, length));
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        if (this.parameterSets < 1) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.unbindParameter(i);
            }
            this.parameterSets = 0;
        }
    }

    @Override
    public void setObject(int i, Object x, int targetJdbcType) throws SQLException {
        this.setObject(i, x);
    }

    @Override
    public void setObject(int i, Object x, int targetJdbcType, int scale) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (targetJdbcType == 2 || targetJdbcType == 3) {
            this.setGeneric(i, x, new Integer(scale));
        } else {
            this.setObject(i, x);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void setObject(int i, Object x) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        int jdbcType = this.getParameterTypeAbsolute(i);
        if (jdbcType == -1 || jdbcType == -4) {
            if (x instanceof String) {
                if (((String)x).length() > 10000) {
                    this.setCharacterStream(i, (Reader)new StringReader((String)x), -1);
                    return;
                } else {
                    this.setGeneric(i, x);
                }
                return;
            } else if (x instanceof byte[]) {
                if (((byte[])x).length > 10000) {
                    this.setBinaryStream(i, (InputStream)new ByteArrayInputStream((byte[])x), ((byte[])x).length);
                    return;
                } else {
                    this.setGeneric(i, x);
                }
                return;
            } else if (x instanceof InputStream) {
                if (jdbcType == -1) {
                    this.setAsciiStream(i, (InputStream)x, -1);
                    return;
                } else {
                    this.setBinaryStream(i, (InputStream)x, -1);
                }
                return;
            } else if (x instanceof Reader && jdbcType == -1) {
                this.setCharacterStream(i, (Reader)x, -1);
                return;
            } else if (x instanceof Clob && jdbcType == -1) {
                this.setClob(i, (Clob)x);
                return;
            } else {
                if (jdbcType == -4) {
                    throw new SQLException("Unsupported type conversion: " + x.getClass().getName() + " to java.sql.Types.LONGVARBINARY.", "S1000");
                }
                if (!(x instanceof Integer) && !(x instanceof Long) && !(x instanceof Short) && !(x instanceof Float) && !(x instanceof Double) && !(x instanceof BigDecimal) && !(x instanceof Boolean) && !(x instanceof Date) && !(x instanceof Time) && !(x instanceof Timestamp) && !(x instanceof Byte)) throw new SQLException("Unsupported type conversion: " + x.getClass().getName() + " to java.sql.Types.LONGVARCHAR.", "S1000");
                this.setGeneric(i, x);
            }
            return;
        } else if (jdbcType == 2002) {
            try {
                CacheListBuilder serial = (CacheListBuilder)((CacheStruct)x).serialize2();
                CacheListBuilder list = new CacheListBuilder(null);
                list.set(1);
                list.set(serial);
                this.setGeneric(i, list);
                return;
            }
            catch (Exception e) {
                SQLException ex = new SQLException("Invalid value for STRUCT.", "S1000");
                ex.initCause(e);
                throw ex;
            }
        } else {
            this.setGeneric(i, x);
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        this.genericExecuteCalled = true;
        if (this.multipleResultSets) {
            return this.executeMultipleResultSets(true);
        }
        if (this.statementType == 1 || this.statementType == 12) {
            this.Query();
            this.updateCnt = -1;
            return true;
        }
        this.Update();
        if (this.parameterSets == 0) {
            this.updateCnt = this.input.wire.getInt();
        }
        if (this.statementType == 15) {
            this.connection.resetConnection(false);
        }
        return false;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("execute(String sql) form not allowed.", "S1000");
    }

    synchronized void prepare(String sql) throws SQLException {
        this.cleanUp();
        this.preparse(sql);
        this.prepareInternal();
    }

    synchronized void prepare(String sql, int statementType, long paramCount) throws SQLException {
        this.cleanUp();
        this.preparse(sql, statementType, paramCount);
        this.prepareInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void prepareInternal() throws SQLException {
        if (this.statementType == 7) {
            throw new SQLException("No output parameters allowed.");
        }
        if (this.statementType == 2) {
            if (!this.getCachedInfo(this.sqlText)) {
                this.prepareStoredProcedure();
            }
            return;
        }
        if (this.statementType == 14) {
            this.prepareDialect();
            return;
        }
        if (this.statementType != 8 && this.statementType != 9 && this.getCachedInfo(this.sqlText)) {
            return;
        }
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARE);
            this.output.wire.setSQLText(this.sqlText);
            if (this.connection.protocolVersion >= 45) {
                this.output.wire.append(this.additionalParameterInfo);
            }
            this.output.send(this.connection.messageCount.getCount());
            this.input.readMessage(this, 0, 0);
            if (this.statementType == 1) {
                this.columnInfo(this.input.wire);
                this.parameterInfo(this.input.wire);
            } else {
                this.parameterInfo(this.input.wire);
            }
        }
        if (this.connection.connectionInfo.protocolVersion > 50) {
            if (this.addToServerCache) {
                this.connection.addCachedPrepare(this, this.statementType == 1);
            } else if (this.connection.connectionInfo.protocolVersion >= 44) {
                this.connection.recycledServerCursorNumber = this.serverCursorNumber;
            }
        } else if (this.statementType == 1) {
            if (this.resultSetType == 1003) {
                this.connection.addCachedPrepare(this, true);
            }
        } else if (this.statementType != 8 && this.statementType != 9) {
            this.connection.addCachedPrepare(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void prepareDialect() throws SQLException {
        this.serverCursorNumber = this.connection.getServerCursorNumber();
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARE_DIALECT);
            this.output.wire.set(this.sqlDialect);
            this.output.wire.set(this.sqlText);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readMessage(this, 0, 0);
            int parameterCount = this.input.wire.getInt();
            for (int i = 0; i < parameterCount; ++i) {
                this.parameters.add(new CacheStatement.Parameter());
            }
            this.readParameterData(this.input.wire, parameterCount, false);
            this.multipleResultSets = true;
        }
    }

    synchronized void setGeneric(int i, Object obj) throws SQLException {
        if (this.execParams != null) {
            ExecParameter execParam = this.getExecParam(i);
            execParam.value = obj;
            execParam.mode = 1;
            execParam.bound = true;
            return;
        }
        this.setGeneric(i, obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setGeneric(int i, Object obj, Object whatever) throws SQLException {
        if (this.execParams != null) {
            ExecParameter execParam = this.getExecParam(i);
            execParam.value = obj;
            execParam.mode = 1;
            execParam.bound = true;
            execParam.whatever = whatever;
            return;
        }
        List list = this.parameters;
        synchronized (list) {
            ((CacheStatement.Parameter)this.parameters.get(this.getAbsoluteParameterIndex(i))).bind(obj, whatever, this.parameterSets);
        }
    }

    @Override
    void validateParameters() throws SQLException {
        if (this.parameterListMismatchException && !this.namedParameters) {
            throw new SQLException("Parameter list mismatch.", "07001", 7001);
        }
        int i = 0;
        if (this.hasReturnValue == 1 || this.hasReturnValue == 3) {
            i = 1;
        }
        while (i < this.parameters.size()) {
            CacheStatement.Parameter parameter = (CacheStatement.Parameter)this.parameters.get(i);
            if (0 == parameter.mode) {
                if (this.namedParameters) {
                    parameter.mode = 6;
                } else {
                    throw new SQLException("Not all parameters bound/registered.", "07001", 7001);
                }
            }
            ++i;
        }
    }

    public synchronized void setDefault(int i) throws SQLException {
        ((CacheStatement.Parameter)this.parameters.get((int)this.getAbsoluteParameterIndex((int)i))).mode = 6;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        ++this.parameterSets;
        for (int i = 0; i < this.parameters.size(); ++i) {
            CacheStatement.Parameter par = (CacheStatement.Parameter)this.parameters.get(i);
            if (par.mode == 5 || par.values.size() == this.parameterSets) continue;
            if (this.parameterSets != 1 && par.values.size() + 1 == this.parameterSets) {
                par.whatever.add(par.whatever.get(par.values.size() - 1));
                par.values.add(par.values.get(par.values.size() - 1));
                continue;
            }
            throw new SQLException("Not all parameters bound for this addBatch.", "S1000");
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("addBatch(String sql) form not allowed.", "S1000");
    }

    @Override
    public void setCharacterStream(int i, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setGeneric(i, null);
            return;
        }
        this.setGeneric(i, new CacheStatement.StreamWrapper(reader, 4, length));
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getParameterTypeAbsolute(i) != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(i, x.getBinaryStream(), (int)x.length());
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        if (x == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getParameterTypeAbsolute(i) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(i, x.getCharacterStream(), (int)x.length());
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        return new CacheResultSetMetaData(this);
    }

    @Override
    public void setDate(int i, Date x, Calendar cal) throws SQLException {
        this.setGeneric(i, x, cal);
    }

    @Override
    public void setTime(int i, Time x, Calendar cal) throws SQLException {
        this.setGeneric(i, x, cal);
    }

    @Override
    public void setTimestamp(int i, Timestamp x, Calendar cal) throws SQLException {
        this.setGeneric(i, x, cal);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setGeneric(paramIndex, null);
    }

    @Override
    public void setURL(int i, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new CacheParameterMetaData(this.parameters);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkIfUnicodeServer();
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkIfUnicodeServer();
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setClob(int i, Reader reader, long length) throws SQLException {
        if (reader == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getParameterTypeAbsolute(i) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(i, reader, length);
    }

    @Override
    public void setBlob(int i, InputStream inputStream, long length) throws SQLException {
        if (inputStream == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getParameterTypeAbsolute(i) != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(i, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIfUnicodeServer();
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            int available = 0;
            try {
                available = x.available();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (available == 0 || available > Integer.MAX_VALUE) {
                throw new SQLException("Stream too long: " + length);
            }
            length = available;
        }
        this.setAsciiStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            int available = 0;
            try {
                available = x.available();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (available == 0 || available > Integer.MAX_VALUE) {
                throw new SQLException("Stream too long: " + length);
            }
            length = available;
        }
        this.setBinaryStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Stream too long: " + length);
        }
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, -1);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkIfUnicodeServer();
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int i, Reader reader) throws SQLException {
        if (reader == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getParameterTypeAbsolute(i) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(i, reader);
    }

    @Override
    public void setBlob(int i, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setGeneric(i, null);
            return;
        }
        if (this.getParameterTypeAbsolute(i) != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(i, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkIfUnicodeServer();
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkIfUnicodeServer();
        this.setClob(parameterIndex, value);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private void checkIfUnicodeServer() throws SQLException {
        if (!this.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server.");
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        int i;
        if (this.closed) {
            throw new SQLException("This Statement object is closed.", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open.", "08003");
        }
        if (this.parameterSets == 0) {
            return new int[0];
        }
        for (i = 0; i < this.parameters.size(); ++i) {
            if (!this.isOutParameter(i)) continue;
            throw new SQLException("INOUT/OUT parameters not permitted.", "S1000");
        }
        boolean buException = false;
        SQLException sqlException = null;
        try {
            this.executeUpdate();
        }
        catch (SQLException sqlExc) {
            sqlException = sqlExc;
            if (this.input.wire.isEnd()) {
                throw new BatchUpdateException(sqlExc.getMessage(), sqlExc.getSQLState(), sqlExc.getErrorCode(), new int[0]);
            }
            buException = true;
        }
        int sets = this.parameterSets;
        this.parameterSets = 0;
        int[] updateCount = new int[sets];
        for (i = 0; i < sets; ++i) {
            updateCount[i] = this.input.wire.getInt();
            if (updateCount[i] != -3) continue;
            buException = true;
        }
        if (buException) {
            if (sets == 1 && updateCount[0] == 0) {
                updateCount[0] = -3;
            }
            if (sqlException == null) {
                throw new BatchUpdateException("Not all rows updated.", updateCount);
            }
            throw new BatchUpdateException(sqlException.getMessage(), sqlException.getSQLState(), sqlException.getErrorCode(), updateCount);
        }
        this.clearBatch();
        return updateCount;
    }
}

