/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CachePreparedStatement;
import com.intersys.sqf.Address;
import com.intersys.sqf.Master;
import com.intersys.sqf.Pipe;
import com.intersys.sqf.PipeJDBC;
import com.intersys.sqf.Record;
import com.intersys.sqf.Sharder;
import com.intersys.sqf.Utl;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public final class CachePreparedShardedStatement
extends CachePreparedStatement {
    int m_pending;
    final Record m_record;
    final Sharder m_sharder;
    final ExecutorService m_threads;
    final List<Pipe> m_pipes = new ArrayList<Pipe>(256);

    public CachePreparedShardedStatement(Master m, CacheConnection c, int rst, int rsc, String sql, String agk) throws SQLException {
        super(c, rst, rsc, sql, agk);
        this.m_record = new Record(this.parameters.size());
        this.m_sharder = m.getSharder(sql, "SQ");
        for (Address s : this.m_sharder.getShards()) {
            this.m_pipes.add(this.pipe(s, sql, c.moreConnectionInfo));
        }
        this.m_threads = this.pool(c.moreConnectionInfo);
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        int i = this.m_sharder.getShard(this.m_record);
        return this.m_pipes.get(i).insert(this.m_record);
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        this.m_record.offset = this.m_pending++;
        int i = this.m_sharder.getShard(this.m_record);
        this.m_pipes.get(i).sink(this.m_record);
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        final int[] r = new int[this.m_pending];
        if (this.m_pending > 0) {
            this.m_pending = 0;
            ArrayList<Future<Void>> fs = new ArrayList<Future<Void>>(this.m_pipes.size());
            for (final Pipe p : this.m_pipes) {
                fs.add(this.m_threads.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws SQLException {
                        p.flush(r);
                        return null;
                    }
                }));
            }
            Throwable e = null;
            for (Future future : fs) {
                try {
                    future.get();
                }
                catch (Exception x) {
                    e = x;
                }
            }
            if (e != null) {
                throw new BatchUpdateException(r, e.getCause());
            }
        }
        return r;
    }

    @Override
    public void close() throws SQLException {
        for (Pipe p : this.m_pipes) {
            p.close();
        }
        this.m_threads.shutdown();
        this.m_sharder.close();
        super.close();
    }

    @Override
    synchronized void setGeneric(int ordinal, Object value) {
        this.m_record.fields[ordinal - 1] = value;
    }

    Pipe pipe(Address shard, String query, Properties info) throws SQLException {
        return new PipeJDBC(shard, query, info);
    }

    ExecutorService pool(Properties info) {
        int n = this.m_sharder.getShards().size();
        String s = info.getProperty("LoaderPoolSize", "" + n);
        try {
            n = Utl.clamp(1, Integer.parseInt(s), n);
            Utl.log("loader thread pool size = %d", n);
        }
        catch (NumberFormatException e) {
            Utl.log("bad value '%s' for connection property 'LoaderPoolSize'; defaulting to %d", s, n);
        }
        ThreadFactory f = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        };
        return Executors.newFixedThreadPool(n, f);
    }
}

