/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheConnectionPoolDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class CachePooledConnection
implements PooledConnection {
    private ConnectionEventListener connectionListener = null;
    private Object statementListener = null;
    private CacheConnectionPoolDataSource myDataSource;
    private CacheConnection physicalConnection;
    private String url;
    private String user;
    private String password;
    private boolean closed = false;

    CachePooledConnection(CacheConnectionPoolDataSource cpds, String usr, String pwd) throws SQLException {
        this.myDataSource = cpds;
        this.url = this.myDataSource.getURL();
        this.user = usr;
        this.password = pwd;
        this.physicalConnection = new CacheConnection(cpds, this.user, this.password, this);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException("Unable to get connection: PooledConnection object is closed");
        }
        return this.physicalConnection;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.physicalConnection.pooled = null;
        this.physicalConnection.close();
        this.closed = true;
        this.connectionListener = null;
        if (this.myDataSource.pool.contains(this)) {
            this.myDataSource.pool.remove(this);
        } else {
            --this.myDataSource.activeConnections;
        }
        this.myDataSource = null;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener l) {
        if (!this.closed) {
            this.connectionListener = l;
        }
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener l) {
        this.connectionListener = null;
    }

    synchronized void release() {
        this.connectionListener.connectionClosed(new ConnectionEvent(this));
    }

    synchronized void returnToPool() {
        if (!this.myDataSource.pool.contains(this)) {
            this.myDataSource.pool.add(this);
        }
        --this.myDataSource.activeConnections;
    }

    boolean checkConnectionParameters(String rl, String usr, String pwd) {
        return this.url.equals(rl) && this.user.equals(usr) && this.password.equals(pwd);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (!this.closed) {
            this.statementListener = listener;
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementListener = null;
    }
}

