/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheInputStream;
import com.intersys.jdbc.CacheOutputStream;
import com.intersys.jdbc.CacheReader;
import com.intersys.jdbc.CacheWriter;
import com.intersys.jdbc.RealStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class CacheClob
extends RealStream
implements Clob {
    CacheClob(CacheConnection conn, byte[] oref, int scn, int streamType, int sqlType) throws SQLException {
        super(conn, null, oref, scn, streamType, sqlType, 0);
        this.getStreamSize();
    }

    CacheClob(CacheConnection conn, String oid, int scn, int streamType, int sqlType) throws SQLException {
        super(conn, oid, null, scn, streamType, sqlType, 0);
        this.getSize();
    }

    CacheClob(CacheConnection conn, byte[] h, int scn) throws SQLException {
        super(conn, null, h, scn, 0, -1, 0);
        this.getStreamSize();
    }

    @Override
    public long length() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        return this.size;
    }

    @Override
    public synchronized String getSubString(long pos, int len) throws SQLException {
        try {
            byte[] byteStream = this.getByteStream(pos, len);
            if (byteStream == null) {
                return null;
            }
            return new String(byteStream, "UTF-8");
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        if (this.streamOID != null) {
            return new CacheReader(this.connection, this.streamOID, this.cursorNumber, this.sqlType, 0);
        }
        return new CacheReader(this);
    }

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        if (this.streamOID != null) {
            return new CacheInputStream(this.connection, this.streamOID, this.cursorNumber, 0, this.sqlType, 0);
        }
        return new CacheInputStream(this);
    }

    @Override
    public synchronized long position(String pattern, long start) throws SQLException {
        return this.getPosition(pattern.getBytes(), start);
    }

    @Override
    public synchronized long position(Clob pattern, long start) throws SQLException {
        return this.getPosition(pattern.getSubString(0L, (int)pattern.length()).getBytes(), start);
    }

    @Override
    public int setString(long pos, String bytes) throws SQLException {
        return this.setString(pos, bytes, 0, bytes.length());
    }

    @Override
    public int setString(long pos, String bytes, int offset, int len) throws SQLException {
        int count = this.sendBytes(pos, bytes.getBytes(), offset, len);
        this.getStreamSize();
        return count;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return new CacheOutputStream(this, pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        return new CacheWriter(this, pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.truncateStream(len);
        this.getStreamSize();
    }

    @Override
    public void free() throws SQLException {
        try {
            this.close();
        }
        catch (Exception e) {
            throw new SQLException("Error freeing clob " + e.getMessage(), "S1000");
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        return new CacheReader(this.getSubString(pos, (int)length));
    }
}

