/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBufferUtils;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheList;
import com.intersys.jdbc.CacheListBuilder;
import com.intersys.jdbc.CacheMsgHeader;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.LogFileStream;
import com.intersys.util.ListUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class CacheBufferWrite
extends CacheListBuilder {
    private static final int STREAM_BUF_SIZE = 32768;
    private static final int maxBufferSize = 65536;
    private static int CHUNKSIZE = 256;
    private int maxFieldSize = 0;

    public CacheBufferWrite(String locale) {
        super(CHUNKSIZE + 14, locale);
        this.clearList();
    }

    public CacheBufferWrite(int nLen, String locale) {
        super(nLen + 14, locale);
    }

    @Override
    public void clearList() {
        this.m_iLength = 14;
        this.m_iOffset = 14;
        this.m_lastReadOffset = 14;
    }

    public void setConnectionInfo(ConnectionInfo info) {
        this.setLocale(info.serverLocale);
        this.m_isUnicodeServer = info.isUnicodeServer;
    }

    void dumpData(OutputStream out, int count, LogFileStream logFile) throws IOException {
        this.dumpData(out, count, this.m_iLength, logFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpData(OutputStream out, int count, int length, LogFileStream logFile) throws IOException {
        CacheMsgHeader.setCount(this.m_aData, count);
        if (length == 14) {
            boolean xys = true;
        }
        CacheMsgHeader.setMessageLength(this.m_aData, length - 14);
        OutputStream outputStream = out;
        synchronized (outputStream) {
            out.write(this.m_aData, 0, length);
            out.flush();
        }
        if (logFile != null) {
            logFile.dump(this.m_aData, 0, length, 1, null);
        }
    }

    public void writeHeader(int statementID, byte[] type) {
        CacheMsgHeader.setStatementID(this.m_aData, statementID);
        CacheMsgHeader.setMsgType(this.m_aData, type);
        this.m_iOffset = 14;
        this.m_iLength = 14;
    }

    public void writeHeader(byte[] type) {
        this.writeHeader(0, type);
    }

    void set2ByteInt(int data) {
        this.stuffRawInt(this.m_aData, this.m_iOffset, data, 2);
        this.m_iOffset += 2;
        this.m_iLength += 2;
    }

    void setRawBytes(byte[] b) {
        this.checkBufferSize(b.length + 14);
        System.arraycopy(b, 0, this.m_aData, 14, b.length);
        this.m_iLength = this.m_iOffset += b.length + 14;
    }

    void setParameter(Object value) throws SQLException {
        this.setObject(value);
    }

    void setParameter(Object value, int paramType) throws SQLException {
        block34: {
            if (value instanceof Date) {
                if (1091 == paramType) {
                    this.setH((Date)value);
                } else if (1093 == paramType) {
                    this.setPosix((Date)value);
                } else {
                    this.set((Date)value);
                }
            } else if (value instanceof Time) {
                if (1092 == paramType) {
                    this.setH((Time)value);
                } else if (1093 == paramType) {
                    this.setPosix((Time)value);
                } else {
                    this.set((Time)value);
                }
            } else if (value instanceof Timestamp) {
                if (1093 == paramType) {
                    this.setPosix((Timestamp)value);
                } else if (1091 == paramType) {
                    this.setH(new Date(((Timestamp)value).getTime()));
                } else if (1092 == paramType) {
                    this.setH(new Time(((Timestamp)value).getTime()));
                } else {
                    this.set((Timestamp)value);
                }
            } else if (value instanceof String) {
                try {
                    if (1091 == paramType) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        java.util.Date d = dateFormat.parse((String)value);
                        this.setH(d);
                        break block34;
                    }
                    if (1092 == paramType) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
                        java.util.Date d = dateFormat.parse((String)value);
                        Time t = new Time(d.getTime());
                        int iFraction = ((String)value).indexOf(46);
                        if (iFraction > 0) {
                            this.setH(t, ((String)value).substring(iFraction + 1), null);
                        } else {
                            this.setH(t);
                        }
                        break block34;
                    }
                    if (1093 == paramType) {
                        try {
                            Timestamp tx = Timestamp.valueOf((String)value);
                            this.setPosix(tx);
                        }
                        catch (Exception ex) {
                            this.set((String)value);
                        }
                        break block34;
                    }
                    this.setObject(value);
                }
                catch (ParseException e) {
                    if (1091 == paramType) {
                        throw new SQLException("Invalid Date", "22008", 22008);
                    }
                    if (1092 == paramType) {
                        throw new SQLException("Invalid Time", "22008", 22008);
                    }
                    if (1093 == paramType) {
                        throw new SQLException("Invalid Timestamp", "22008", 22008);
                    }
                    e.printStackTrace();
                }
            } else {
                this.setObject(value);
            }
        }
    }

    public void setParameter(Object value, Object object2, int paramType) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        if (1091 == paramType || 1092 == paramType || 1093 == paramType) {
            if (value instanceof Date) {
                if (1091 == paramType) {
                    this.setH((Date)value, (Calendar)object2);
                } else if (1093 == paramType) {
                    this.setPosix((Date)value, (Calendar)object2);
                } else {
                    this.set((Date)value, (Calendar)object2);
                }
            } else if (value instanceof Time) {
                if (1092 == paramType) {
                    this.setH((Time)value, (Calendar)object2);
                } else if (1093 == paramType) {
                    this.setPosix((Time)value, (Calendar)object2);
                } else {
                    this.set((Time)value, (Calendar)object2);
                }
            } else if (value instanceof Timestamp) {
                if (1093 == paramType) {
                    this.setPosix((Timestamp)value, (Calendar)object2);
                } else if (1091 == paramType) {
                    this.setH(new Date(((Timestamp)value).getTime()), (Calendar)object2);
                } else if (1092 == paramType) {
                    this.setH(new Time(((Timestamp)value).getTime()), (Calendar)object2);
                } else {
                    this.set((Timestamp)value);
                }
            }
        } else {
            this.setParameter(value, object2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParameter(Object value, Object object2) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        } else if (value instanceof Date) {
            this.set((Date)value, (Calendar)object2);
            return;
        } else if (value instanceof Time) {
            this.set((Time)value, (Calendar)object2);
            return;
        } else if (value instanceof Timestamp) {
            this.set((Timestamp)value, (Calendar)object2);
            return;
        } else {
            if (!(object2 instanceof Integer)) throw new SQLException("Type out of range " + value.getClass().getName() + " " + object2.getClass().getName(), "S1003");
            if (value instanceof Number) {
                this.set(new BigDecimal(value.toString()).setScale((int)((Integer)object2), 1));
                return;
            } else {
                if (!(value instanceof String)) throw new SQLException("Type out of range", "S1003");
                this.set(new BigDecimal(value.toString()).setScale((int)((Integer)object2), 1));
            }
        }
    }

    public void setSQLText(String sqlText) throws SQLException {
        int len = sqlText.length();
        if (len == 0) {
            this.stuffLatin1(sqlText);
            return;
        }
        int bindex = 0;
        boolean bIsWide = this.isWide(sqlText);
        int chunksize = bIsWide ? 15952 : 31904;
        int chunknum = len % chunksize != 0 ? len / chunksize + 1 : len / chunksize;
        this.set(chunknum);
        if (this.m_isUnicodeServer && bIsWide) {
            for (int i = 1; i <= chunknum; ++i) {
                int eindex = bindex + chunksize;
                eindex = eindex > len ? len : eindex;
                this.stuffUnicode(sqlText.substring(bindex, eindex));
                bindex = eindex;
            }
        } else {
            for (int i = 1; i <= chunknum; ++i) {
                int eindex = bindex + chunksize;
                eindex = eindex > len ? len : eindex;
                this.stuffLatin1(sqlText.substring(bindex, eindex));
                bindex = eindex;
            }
        }
    }

    int sendContinuationMsg(OutputStream outputStream, CacheConnection connection, int messageCount, int flushBufferSize) throws SQLException {
        try {
            if (messageCount == -1) {
                messageCount = connection.messageCount.getCount();
            }
            int carryover = this.m_iLength - flushBufferSize;
            int id = CacheBufferUtils.get4ByteIntRaw(this.m_aData, 8) & Integer.MAX_VALUE;
            CacheMsgHeader.setStatementID(this.m_aData, id | Integer.MIN_VALUE);
            this.dumpData(outputStream, messageCount, flushBufferSize, connection.logFile);
            if (carryover > 0) {
                System.arraycopy(this.m_aData, flushBufferSize, this.m_aData, 14, carryover);
            }
            this.m_iOffset = this.m_iLength = carryover + 14;
            CacheMsgHeader.setStatementID(this.m_aData, id);
        }
        catch (Exception e) {
            throw new SQLException("Error writing parameters " + e.getMessage());
        }
        return messageCount;
    }

    public int setParameter(OutputStream outputStream, CacheConnection connection, int messageCount, Object value, int ParamType) throws SQLException {
        if (this.m_iLength > 32768) {
            int flushBufferSize = this.m_iLength;
            if (this.m_iLength > 65536) {
                flushBufferSize = 65536;
            }
            messageCount = this.sendContinuationMsg(outputStream, connection, messageCount, flushBufferSize);
        }
        this.setParameter(value, ParamType);
        return messageCount;
    }

    void setMaxFieldSize(int max) {
        this.maxFieldSize = max;
    }

    int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    void writeBatchCount(int count) {
        if (count == -1) {
            this.m_iLength = this.m_iOffset += 4;
        }
        this.stuffRawInt(this.m_aData, 14, count, 4);
    }

    void reserveHeader() {
        if (this.m_iLength < 14) {
            this.checkBufferSize(14);
        }
        this.m_aData[0] = 0;
        this.m_aData[1] = 0;
        this.m_aData[2] = 0;
        this.m_aData[3] = 0;
        this.m_aData[4] = 0;
        this.m_aData[5] = 0;
        this.m_aData[6] = 0;
        this.m_aData[7] = 0;
        this.m_aData[8] = 0;
        this.m_aData[9] = 0;
        this.m_aData[10] = 0;
        this.m_aData[11] = 0;
        this.m_aData[12] = 0;
        this.m_aData[13] = 0;
        this.m_iOffset = 14;
        this.m_iLength = 14;
    }

    public void resetHeader() {
        this.m_iLength = 14;
        this.m_iOffset = 14;
    }

    void writeContinuationHeader(int statementID, byte[] type, boolean setContinuation) {
        CacheMsgHeader.setMessageLength(this.m_aData, this.m_iLength - 14);
        if (setContinuation) {
            CacheMsgHeader.setStatementID(this.m_aData, statementID | Integer.MIN_VALUE);
        } else {
            CacheMsgHeader.setStatementID(this.m_aData, statementID);
        }
        CacheMsgHeader.setMsgType(this.m_aData, type);
    }

    public static int writeStream(InputStream in, int streamType, int sqlType, byte[] data, int len, int offset, int lengthOffset, String serverLocale) throws IOException {
        int bytesWritten;
        int charsRead = 0;
        if (streamType == 0) {
            int maxlen = data.length - offset - 1;
            byte[] buffer = new byte[32768];
            while (len > charsRead) {
                int charsread = len > 32768 ? 32768 : len - charsRead;
                if ((charsread = in.read(buffer, 0, charsread)) != -1) {
                    boolean resizeRequired = false;
                    for (int i = 0; i < charsread; ++i) {
                        int utf8bytes = ListUtil.getUTF8FromAscii(buffer, i, data, offset + bytesWritten, maxlen - bytesWritten, serverLocale);
                        if (utf8bytes == 0) {
                            resizeRequired = true;
                            break;
                        }
                        ++charsRead;
                        bytesWritten += utf8bytes;
                    }
                    if (!resizeRequired) continue;
                }
                break;
            }
        } else if (streamType == 1) {
            int bytes;
            for (bytesWritten = 0; len > bytesWritten && (bytes = in.read(data, offset + bytesWritten, len - bytesWritten)) != -1; bytesWritten += bytes) {
            }
            charsRead = bytesWritten;
        } else {
            throw new IOException("Unsupported Stream type: " + streamType);
        }
        if (lengthOffset >= 0) {
            CacheList.stuffRawInt(data, lengthOffset, charsRead, 4);
        }
        return bytesWritten;
    }

    public void writeInputStream(InputStream in, int len, int streamType, int sqlType) throws SQLException {
        try {
            int originalOffset = this.m_iOffset;
            int needed = streamType == 0 ? len * 2 : len;
            this.checkBufferSize(needed);
            String locale = this.m_isUnicodeServer ? null : this.getLocale();
            this.m_iLength += 4;
            this.m_iOffset += 4;
            int bytes = CacheBufferWrite.writeStream(in, streamType, sqlType, this.m_aData, len, this.m_iOffset, originalOffset, locale);
            this.m_iOffset += bytes;
            this.m_iLength += bytes;
        }
        catch (IOException e) {
            throw new SQLException("Error writing stream: " + e.getMessage());
        }
    }

    void writeReader(Reader reader, int len) throws SQLException {
        int startOffset = this.m_iOffset;
        this.m_iLength += 4;
        this.m_iOffset += 4;
        try {
            int chars = 0;
            int bytes = 0;
            int needed = this.m_isUnicodeServer ? len * 3 : len * 2;
            this.checkBufferSize(needed);
            char[] buffer = new char[32768];
            while (len > 0) {
                int charsread = len > 32768 ? 32768 : len;
                if ((charsread = reader.read(buffer, 0, charsread)) == -1) break;
                chars += charsread;
                len -= charsread;
                for (int i = 0; i < charsread; ++i) {
                    char c = buffer[i];
                    int n = ListUtil.getUTFBytes(c, this.m_aData, this.m_iOffset, this.m_aData.length - this.m_iOffset);
                    bytes += n;
                    this.m_iOffset += n;
                    if (n > 0) continue;
                    throw new SQLException("Buffer length is not enough", "S1000");
                }
            }
            this.m_iLength += bytes;
            CacheList.stuffRawInt(this.m_aData, startOffset, chars, 4);
        }
        catch (IOException e) {
            throw new SQLException("Error writing stream: " + e.getMessage());
        }
    }

    @Override
    public String toString() {
        byte[] buffer = new byte[this.m_iLength - 14];
        System.arraycopy(this.m_aData, 14, buffer, 0, this.m_iLength - 14);
        return "Header +" + CacheList.toString(this.m_aData, this.m_iLength, null);
    }
}

