/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathVariableResolver;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.scalable.BinaryNav;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLUtil;
import oracle.xml.xpath.OrExpr;
import oracle.xml.xpath.PathExpr;
import oracle.xml.xpath.XPathConstantExpr;
import oracle.xml.xpath.XPathContext;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathExtFunction;
import oracle.xml.xpath.XPathFunctionCall;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XPathVarReference;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JXPathExpression
implements XPathExpression {
    private String exprString;
    private XSLExprBase expression;
    private XPathVariableResolver varResolver;
    private boolean enableException;
    private XMLSchema schema;
    private boolean secure;
    private EntityResolver entResolver;
    private int depth = 0;

    JXPathExpression(XSLExprBase xSLExprBase, XPathVariableResolver xPathVariableResolver, String string) {
        this.exprString = string;
        this.expression = xSLExprBase;
        this.varResolver = xPathVariableResolver;
    }

    public String toString() {
        return this.exprString;
    }

    public boolean hasBackwardAxis() {
        return this.expression.backAxis;
    }

    void setXMLSchema(XMLSchema xMLSchema) {
        this.schema = xMLSchema;
    }

    boolean supportIndex() {
        return this.expression.supportIndex();
    }

    void setSecure(boolean bl) {
        this.secure = bl;
    }

    void setEntityResolver(EntityResolver entityResolver) {
        this.entResolver = entityResolver;
    }

    @Override
    public Object evaluate(Object object, QName qName) throws XPathExpressionException {
        if (qName == null) {
            throw new NullPointerException();
        }
        XPathRuntimeContext xPathRuntimeContext = null;
        XMLError xMLError = new XMLError();
        try {
            Object object2;
            xPathRuntimeContext = new XPathRuntimeContext();
            xPathRuntimeContext.init();
            xPathRuntimeContext.setXMLSchema(this.schema);
            if (this.varResolver != null) {
                xPathRuntimeContext.setVarResolver(this.varResolver);
            }
            XMLNode xMLNode = null;
            XPathContext xPathContext = null;
            if (object instanceof XMLNode) {
                xMLNode = (XMLNode)object;
            } else if (object instanceof XPathContext) {
                ((XPathContext)object).resetXPathError();
                xPathContext = (XPathContext)object;
                xMLNode = (XMLNode)xPathContext.getContextNode();
                if (xMLNode == null) {
                    xMLNode = new XMLDocument();
                }
                if ((object2 = xPathContext.getXPathVariableResolver()) != null) {
                    xPathRuntimeContext.setVarResolver((XPathVariableResolver)object2);
                }
            } else if (object instanceof Node) {
                xMLNode = XMLUtil.getXMLDocumentFromDoc((Node)object);
            } else if (object == null) {
                xMLNode = new XMLDocument();
            } else if (object instanceof BinaryNav) {
                if (!this.expression.supportIndex()) {
                    throw new UnsupportedOperationException("Expression does not support binary index");
                }
                object2 = (BinaryNav)object;
                xPathRuntimeContext.setBinaryNav((BinaryNav)object2);
                xPathRuntimeContext.setContextIndex(((BinaryNav)object2).getCurrentIndex());
            } else {
                throw new IllegalArgumentException();
            }
            if (xMLNode != null) {
                object2 = xMLNode.getSrcRoot();
                xPathRuntimeContext.addSourceContext((XMLElement)object2, xMLNode.getDocument());
                xPathRuntimeContext.setContextNode(xMLNode);
            }
            xPathRuntimeContext.setContextSize(1);
            xPathRuntimeContext.setContextPosition(1);
            xPathRuntimeContext.setXPathContext(xPathContext);
            xPathRuntimeContext.setEnableException(this.enableException);
            try {
                if (xPathRuntimeContext.getCtxForm() == 0 && this.expression.isStreamable()) {
                    this.expression.streamingEvaluate(xPathRuntimeContext);
                } else {
                    this.expression.evaluate(xPathRuntimeContext);
                }
                object2 = (XPathSequence)xPathRuntimeContext.peekExprValue();
                if (qName.equals(XPathConstants.NODESET)) {
                    return ((XPathSequence)object2).getNodeList();
                }
                if (qName.equals(XPathConstants.NODE)) {
                    if (((XPathSequence)object2).next()) {
                        return XPathSequence.nextNode((OXMLSequence)object2);
                    }
                    return null;
                }
                if (qName.equals(XPathConstants.STRING)) {
                    return ((XPathSequence)object2).getStringValue();
                }
                if (qName.equals(XPathConstants.BOOLEAN)) {
                    return new Boolean(((XPathSequence)object2).getBooleanValue());
                }
                if (qName.equals(XPathConstants.NUMBER)) {
                    return new Double(((XPathSequence)object2).getNumberValue());
                }
                if (qName.equals(XPathContext.OBJECT)) {
                    return ((XPathSequence)object2).getObjectValue();
                }
                if (qName.equals(XPathContext.SEQUENCE)) {
                    return object2;
                }
                throw new IllegalArgumentException();
            }
            catch (XQException xQException) {
                Throwable throwable = xQException.getCause();
                if (throwable != null && throwable instanceof XSLException && throwable.getMessage().equals("TERMINATE PROCESSING")) {
                    throw (XSLException)throwable;
                }
                String string = null;
                String string2 = XMLError.getXPathErrorID(xQException.getErrorCode());
                if (string2 != null) {
                    string = xMLError.getMessage0(Integer.parseInt(string2));
                } else if (throwable != null && throwable instanceof Exception) {
                    string = throwable.getMessage();
                }
                if (string == null) {
                    string = xMLError.getMessage0(23002);
                }
                XPathExpressionException xPathExpressionException = new XPathExpressionException(string);
                if (throwable != null) {
                    xPathExpressionException.initCause(throwable);
                }
                throw xPathExpressionException;
            }
        }
        catch (XSLException xSLException) {
            XPathExpressionException xPathExpressionException = new XPathExpressionException(xSLException.getMessage());
            xPathExpressionException.initCause(xSLException);
            throw xPathExpressionException;
        }
    }

    @Override
    public String evaluate(Object object) throws XPathExpressionException {
        return (String)this.evaluate(object, XPathConstants.STRING);
    }

    @Override
    public Object evaluate(InputSource inputSource, QName qName) throws XPathExpressionException {
        if (inputSource == null) {
            return this.evaluate((Object)null, qName);
        }
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(true);
        dOMParser.setValidationMode(0);
        if (this.secure) {
            dOMParser.setSecureProcessing();
        }
        if (this.entResolver != null) {
            dOMParser.setEntityResolver(this.entResolver);
        }
        try {
            dOMParser.parse(inputSource);
        }
        catch (IOException iOException) {
            XPathExpressionException xPathExpressionException = new XPathExpressionException(iOException.getMessage());
            xPathExpressionException.initCause(iOException);
            throw xPathExpressionException;
        }
        catch (SAXException sAXException) {
            XPathExpressionException xPathExpressionException = new XPathExpressionException(sAXException.getMessage());
            xPathExpressionException.initCause(sAXException);
            throw xPathExpressionException;
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        return this.evaluate(xMLDocument, qName);
    }

    @Override
    public String evaluate(InputSource inputSource) throws XPathExpressionException {
        return (String)this.evaluate(inputSource, XPathConstants.STRING);
    }

    void setEnableException(boolean bl) {
        this.enableException = bl;
    }

    boolean getEnableException() {
        return this.enableException;
    }

    boolean validateXPathExpression() throws XPathException {
        if (!(this.expression instanceof PathExpr)) {
            throw new XPathException(1013, this.exprString);
        }
        int n = this.expression.getStepList().size();
        for (int i = 0; i < n; ++i) {
            XPathStep xPathStep = (XPathStep)this.expression.getStepList().get(i);
            if (xPathStep.axisClass.axisType != 3) {
                throw new XPathException(1013, this.exprString);
            }
            if (xPathStep.prevSeparator == 6) {
                throw new XPathException(1013, this.exprString);
            }
            if (xPathStep.predicates == null) continue;
            XPathPredicate xPathPredicate = xPathStep.predicates;
            for (int j = 0; j < xPathPredicate.predicates.size(); ++j) {
                if (xPathPredicate.predicates.elementAt(j) instanceof XPathConstantExpr) continue;
                throw new XPathException(1013, this.exprString);
            }
        }
        return true;
    }

    boolean validateCreateXPathExpression(XSLExprBase xSLExprBase) throws XPathException {
        if (xSLExprBase == null || !(xSLExprBase instanceof PathExpr)) {
            return false;
        }
        ArrayList arrayList = ((PathExpr)xSLExprBase).getStepList();
        int n = 0;
        for (XSLExprBase xSLExprBase2 : arrayList) {
            if (!(xSLExprBase2 instanceof XPathStep)) {
                return false;
            }
            XPathStep xPathStep = (XPathStep)xSLExprBase2;
            xPathStep.createNode = true;
            if (xPathStep.prevSeparator == 6) {
                throw new XPathException(1013, this.exprString);
            }
            int n2 = xPathStep.getAxisType();
            if (n2 == 8) {
                if (--n > 0) continue;
                return false;
            }
            if (n2 != 3 && n2 != 2) {
                return false;
            }
            ++n;
            XPathPredicate xPathPredicate = xPathStep.getPredicate();
            if (xPathPredicate == null) continue;
            if (xPathPredicate != null && n2 == 2) {
                return false;
            }
            FastVector fastVector = xPathPredicate.predicates;
            int n3 = fastVector.size();
            boolean bl = false;
            for (int i = 0; i < n3; ++i) {
                XSLExprBase xSLExprBase3 = (XSLExprBase)fastVector.elementAt(i);
                if (xSLExprBase3 instanceof XPathVarReference || xSLExprBase3 instanceof XPathExtFunction) {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                    continue;
                }
                if (xSLExprBase3.mayBeExprType(1048632)) {
                    if (bl) {
                        return false;
                    }
                    if (xSLExprBase3.leftExpr != null && !this.isCtxFree(xSLExprBase3.leftExpr) && (xSLExprBase3.rightExpr == null || this.isCtxFree(xSLExprBase3.rightExpr))) {
                        return false;
                    }
                    bl = true;
                    continue;
                }
                if (xSLExprBase3.mayBeExprType(4)) {
                    while (xSLExprBase3 != null && !this.isAttrTest(xSLExprBase3)) {
                        if (xSLExprBase3.operator == 107) {
                            if (this.isAttrTest(xSLExprBase3.leftExpr)) {
                                xSLExprBase3 = xSLExprBase3.rightExpr;
                                continue;
                            }
                            return false;
                        }
                        if (xSLExprBase3 instanceof OrExpr) {
                            xSLExprBase3 = xSLExprBase3.leftExpr;
                            continue;
                        }
                        return false;
                    }
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private boolean isCtxFree(XSLExprBase xSLExprBase) {
        if (xSLExprBase instanceof XPathConstantExpr) {
            return true;
        }
        if (xSLExprBase instanceof XPathExtFunction) {
            return true;
        }
        if (xSLExprBase instanceof XPathFunctionCall) {
            return true;
        }
        if (xSLExprBase instanceof XPathVarReference) {
            return true;
        }
        if (xSLExprBase instanceof PathExpr) {
            PathExpr pathExpr = (PathExpr)xSLExprBase;
            if (pathExpr.filter != null) {
                return this.isCtxFree(pathExpr.filter);
            }
            return pathExpr.root;
        }
        return !(xSLExprBase.leftExpr != null && !this.isCtxFree(xSLExprBase.leftExpr) || xSLExprBase.rightExpr != null && !this.isCtxFree(xSLExprBase.rightExpr));
    }

    private boolean isAttrTest(XSLExprBase xSLExprBase) {
        if (xSLExprBase.operator == 216) {
            PathExpr pathExpr = null;
            XSLExprBase xSLExprBase2 = null;
            if (xSLExprBase.leftExpr instanceof PathExpr) {
                pathExpr = (PathExpr)xSLExprBase.leftExpr;
                xSLExprBase2 = xSLExprBase.rightExpr;
            } else if (xSLExprBase.rightExpr instanceof PathExpr) {
                pathExpr = (PathExpr)xSLExprBase.rightExpr;
                xSLExprBase2 = xSLExprBase.leftExpr;
            } else {
                return false;
            }
            if (!this.isCtxFree(xSLExprBase2)) {
                return false;
            }
            FastVector fastVector = pathExpr.getStepVector();
            if (pathExpr.filter != null || fastVector.size() != 1 || !(fastVector.elementAt(0) instanceof XPathStep)) {
                return false;
            }
            XPathStep xPathStep = (XPathStep)fastVector.elementAt(0);
            return xPathStep.getAxisType() == 2 && xPathStep.predicates == null;
        }
        return false;
    }
}

