/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.gcp;

import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class AuthModelGCPAbstract
extends AuthModelDatabaseNative<AuthModelGCPCredentials> {
    @NotNull
    public AuthModelGCPCredentials createCredentials() {
        return new AuthModelGCPCredentials();
    }

    @NotNull
    public AuthModelGCPCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelGCPCredentials credentials = (AuthModelGCPCredentials)((Object)configuration.getRuntimeAttribute("gcp.iam_credentials"));
        if (credentials == null) {
            credentials = (AuthModelGCPCredentials)super.loadCredentials(dataSource, configuration);
            if (configuration.getAuthProperties() != null) {
                AuthModelGCPAbstract.loadCredentialsFromMap(credentials, configuration.getAuthProperties());
            }
        } else {
            credentials = new AuthModelGCPCredentials(credentials);
            super.loadCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
        }
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelGCPCredentials credentials) {
        LinkedHashMap<String, String> authProperties = new LinkedHashMap<String, String>();
        AuthModelGCPAbstract.saveCredentialsToMap(credentials, authProperties);
        for (Map.Entry ap : authProperties.entrySet()) {
            configuration.setAuthProperty((String)ap.getKey(), (String)ap.getValue());
        }
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelGCPCredentials credentials) throws DBException {
    }

    public static void loadCredentialsFromMap(AuthModelGCPCredentials credentials, Map<String, String> authProperties) {
        credentials.setAuthType((GCPAuthType)CommonUtils.valueOf(GCPAuthType.class, (String)authProperties.get("gcp.authType")));
        credentials.setServiceAccountConfigPath(authProperties.get("gcp.sa_config_path"));
        credentials.setClientId(authProperties.get("gcp.client_id"));
        credentials.setClientSecret(authProperties.get("gcp.client_secret"));
        credentials.setSsoOverCli(CommonUtils.getBoolean((String)authProperties.get("gcp.sso")));
        credentials.resetCache();
    }

    public static void saveCredentialsToMap(@NotNull AuthModelGCPCredentials credentials, Map<String, String> authProperties) {
        if (credentials.getAuthType() != null) {
            authProperties.put("gcp.authType", credentials.getAuthType().name());
        } else {
            authProperties.remove("gcp.authType");
        }
        authProperties.put("gcp.sa_config_path", credentials.getServiceAccountConfigPath());
        authProperties.put("gcp.client_id", credentials.getClientId());
        authProperties.put("gcp.client_secret", credentials.getClientSecret());
        if (credentials.isSsoOverCli()) {
            authProperties.put("gcp.sso", Boolean.TRUE.toString());
        } else {
            authProperties.remove("gcp.sso");
        }
    }

    public boolean supportsDatabaseUser() {
        return true;
    }
}

