/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.palette;

import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPartFactory;
import org.eclipse.gef3.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef3.internal.ui.palette.editparts.GroupEditPart;
import org.eclipse.gef3.internal.ui.palette.editparts.PaletteStackEditPart;
import org.eclipse.gef3.internal.ui.palette.editparts.PinnablePaletteStackEditPart;
import org.eclipse.gef3.internal.ui.palette.editparts.SeparatorEditPart;
import org.eclipse.gef3.internal.ui.palette.editparts.SliderPaletteEditPart;
import org.eclipse.gef3.internal.ui.palette.editparts.TemplateEditPart;
import org.eclipse.gef3.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.gef3.internal.ui.palette.editparts.ToolbarEditPart;
import org.eclipse.gef3.palette.PaletteContainer;
import org.eclipse.gef3.palette.PaletteDrawer;
import org.eclipse.gef3.palette.PaletteEntry;
import org.eclipse.gef3.palette.PaletteRoot;
import org.eclipse.gef3.palette.PaletteSeparator;
import org.eclipse.gef3.palette.PaletteStack;
import org.eclipse.gef3.palette.PaletteTemplateEntry;
import org.eclipse.gef3.palette.PaletteToolbar;
import org.eclipse.gef3.ui.palette.editparts.PaletteEditPart;

public class PaletteEditPartFactory
implements EditPartFactory {
    protected EditPart createDrawerEditPart(EditPart parentEditPart, Object model) {
        return new DrawerEditPart((PaletteDrawer)model);
    }

    @Override
    public EditPart createEditPart(EditPart parentEditPart, Object model) {
        if (model instanceof PaletteRoot) {
            return this.createMainPaletteEditPart(parentEditPart, model);
        }
        if (model instanceof PaletteStack) {
            return this.createStackEditPart(parentEditPart, model);
        }
        if (model instanceof PaletteContainer) {
            Object type = ((PaletteContainer)model).getType();
            if (PaletteDrawer.PALETTE_TYPE_DRAWER.equals(type)) {
                return this.createDrawerEditPart(parentEditPart, model);
            }
            if ("Palette_Group".equals(type) || "Palette_type_Unknown".equals(type)) {
                return this.createGroupEditPart(parentEditPart, model);
            }
            if ("Palette_Toolbar_Group".equals(type)) {
                return this.createToolbarEditPart(parentEditPart, model);
            }
        }
        if (model instanceof PaletteTemplateEntry) {
            return this.createTemplateEditPart(parentEditPart, model);
        }
        if (model instanceof PaletteSeparator) {
            return this.createSeparatorEditPart(parentEditPart, model);
        }
        if (model instanceof PaletteEntry) {
            return this.createEntryEditPart(parentEditPart, model);
        }
        return null;
    }

    protected EditPart createSeparatorEditPart(EditPart parentEditPart, Object model) {
        return new SeparatorEditPart((PaletteSeparator)model);
    }

    protected EditPart createStackEditPart(EditPart parentEditPart, Object model) {
        if (parentEditPart instanceof PaletteEditPart && ((PaletteEditPart)parentEditPart).isToolbarItem()) {
            return new PaletteStackEditPart((PaletteStack)model);
        }
        return new PinnablePaletteStackEditPart((PaletteStack)model);
    }

    protected EditPart createEntryEditPart(EditPart parentEditPart, Object model) {
        return new ToolEntryEditPart((PaletteEntry)model);
    }

    protected EditPart createGroupEditPart(EditPart parentEditPart, Object model) {
        return new GroupEditPart((PaletteContainer)model);
    }

    protected EditPart createToolbarEditPart(EditPart parentEditPart, Object model) {
        return new ToolbarEditPart((PaletteToolbar)model);
    }

    protected EditPart createMainPaletteEditPart(EditPart parentEditPart, Object model) {
        return new SliderPaletteEditPart((PaletteRoot)model);
    }

    protected EditPart createTemplateEditPart(EditPart parentEditPart, Object model) {
        return new TemplateEditPart((PaletteTemplateEntry)model);
    }
}

