/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.util;

import com.couchbase.client.core.annotation.Stability;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Stability.Internal
public class CoreTransactionsSchedulers {
    private static final int DEFAULT_TTL_SECONDS = 60;
    private final Scheduler scheduler = this.createScheduler(100, "cb-txn");
    private final Scheduler schedulerCleanup = this.createScheduler(100, "cb-txn-cleanup");
    private final Scheduler schedulerBlocking = this.createScheduler(100000, "cb-txn-blocking");

    private Scheduler createScheduler(int threadCap, String name) {
        return Schedulers.newBoundedElastic((int)threadCap, (int)Integer.MAX_VALUE, (String)name, (int)60, (boolean)true);
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Scheduler schedulerCleanup() {
        return this.schedulerCleanup;
    }

    public Scheduler schedulerBlocking() {
        return this.schedulerBlocking;
    }

    public void shutdown() {
        this.schedulerCleanup.dispose();
        this.scheduler.dispose();
        this.schedulerBlocking.dispose();
    }
}

