/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.support;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class SpanWrapperUtil {
    public static final String DB_COUCHBASE = "db.couchbase";
    public static final String DB_COUCHBASE_TRANSACTIONS = "db.couchbase.transactions.";

    private SpanWrapperUtil() {
    }

    public static SpanWrapper basic(SpanWrapper span, String op) {
        return span.attribute("db.system", "couchbase").attribute("db.operation", op).attribute("db.couchbase.service", "transactions");
    }

    public static SpanWrapper createOp(@Nullable CoreTransactionAttemptContext ctx, RequestTracer tracer, @Nullable CollectionIdentifier collection, @Nullable String id, String op, @Nullable SpanWrapper attemptSpan) {
        SpanWrapper out = SpanWrapper.create(tracer, op, attemptSpan);
        if (ctx != null) {
            out.attribute("db.couchbase.transactions.transaction_id", ctx.transactionId()).attribute("db.couchbase.transactions.attempt_id", ctx.attemptId());
        }
        SpanWrapperUtil.basic(out, op);
        if (collection != null) {
            out.attribute("db.name", collection.bucket()).attribute("db.couchbase.scope", collection.scope()).attribute("db.couchbase.collection", collection.collection());
        }
        if (id != null) {
            out.attribute("db.couchbase.document", id);
        }
        return out;
    }
}

