/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.query;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.events.request.PreparedStatementRetriedEvent;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.PreparedStatementFailureException;
import com.couchbase.client.core.msg.query.EnhancedPreparedStatementStrategy;
import com.couchbase.client.core.msg.query.LegacyPreparedStatementStrategy;
import com.couchbase.client.core.msg.query.PreparedStatementStrategy;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.retry.RetryOrchestrator;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

@Stability.Internal
public class CoreQueryAccessor {
    private static final int PREPARED_STATEMENT_CACHE_SIZE = 5000;
    private volatile PreparedStatementStrategy strategy;

    public CoreQueryAccessor(Core core) {
        this.strategy = new LegacyPreparedStatementStrategy(core, 5000);
        core.configurationProvider().configs().filter(config -> {
            Set<ClusterCapabilities> caps = config.clusterCapabilities().get((Object)ServiceType.QUERY);
            return caps != null && caps.contains((Object)ClusterCapabilities.ENHANCED_PREPARED_STATEMENTS);
        }).next().subscribe(config -> {
            this.strategy = new EnhancedPreparedStatementStrategy(core, 5000);
        });
    }

    public Mono<QueryResponse> query(QueryRequest request, boolean adhoc) {
        if (adhoc) {
            return this.strategy.executeAdhoc(request);
        }
        return this.strategy.execute(request).onErrorResume(PreparedStatementFailureException.class, (Function)new PreparedRetryFunction(request));
    }

    private class PreparedRetryFunction
    implements Function<PreparedStatementFailureException, Mono<? extends QueryResponse>> {
        private final QueryRequest request;

        public PreparedRetryFunction(QueryRequest request) {
            this.request = Objects.requireNonNull(request);
        }

        @Override
        public Mono<? extends QueryResponse> apply(PreparedStatementFailureException t) {
            if (!t.retryable()) {
                return Mono.error((Throwable)t);
            }
            CoreQueryAccessor.this.strategy.evict(this.request);
            RetryReason retryReason = RetryReason.QUERY_PREPARED_STATEMENT_FAILURE;
            CoreEnvironment env = this.request.context().environment();
            return Mono.fromFuture(this.request.retryStrategy().shouldRetry(this.request, retryReason)).flatMap(retryAction -> {
                Optional<Duration> duration = retryAction.duration();
                if (!duration.isPresent()) {
                    return Mono.error((Throwable)retryAction.exceptionTranslator().apply(t));
                }
                Duration cappedDuration = RetryOrchestrator.capDuration(duration.get(), this.request);
                this.request.context().incrementRetryAttempts(cappedDuration, retryReason);
                env.eventBus().publish(new PreparedStatementRetriedEvent(cappedDuration, this.request.context(), retryReason, t));
                return Mono.delay((Duration)cappedDuration, (Scheduler)env.scheduler()).flatMap(l -> CoreQueryAccessor.this.query(this.request, false));
            });
        }
    }
}

