/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.util.Timeout;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public interface Request<R extends Response> {
    public long id();

    public CompletableFuture<R> response();

    public void succeed(R var1);

    public void fail(Throwable var1);

    default public void cancel(CancellationReason reason) {
        this.cancel(reason, Function.identity());
    }

    public void cancel(CancellationReason var1, Function<Throwable, Throwable> var2);

    public void timeoutRegistration(Timeout var1);

    public RequestContext context();

    public Duration timeout();

    public boolean timeoutElapsed();

    public boolean completed();

    public boolean succeeded();

    public boolean failed();

    public boolean cancelled();

    public CancellationReason cancellationReason();

    public ServiceType serviceType();

    default public String bucket() {
        return null;
    }

    default public NodeIdentifier target() {
        return null;
    }

    public Map<String, Object> serviceContext();

    public RetryStrategy retryStrategy();

    public RequestSpan requestSpan();

    public long createdAt();

    public long absoluteTimeout();

    default public boolean idempotent() {
        return false;
    }

    default public String operationId() {
        return null;
    }

    default public String name() {
        return this.getClass().getSimpleName().replace("Request", "").toLowerCase(Locale.ROOT);
    }
}

