/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager;

import com.couchbase.client.core.annotation.Stability;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreQueryIndexManager {
    public static Map<String, String> getNamedParamsForGetAllIndexes(String bucket, @Nullable String scope, @Nullable String collection) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bucketName", bucket);
        params.put("scopeName", scope);
        params.put("collectionName", collection);
        return params;
    }

    public static String getStatementForGetAllIndexes(String bucket, @Nullable String scope, @Nullable String collection) {
        if (collection != null && scope == null) {
            throw new IllegalArgumentException("When collection is non-null, scope must also be non-null.");
        }
        String bucketCondition = "(bucket_id = $bucketName)";
        String scopeCondition = "(" + bucketCondition + " AND scope_id = $scopeName)";
        String collectionCondition = "(" + scopeCondition + " AND keyspace_id = $collectionName)";
        String whereCondition = collection != null ? collectionCondition : (scope != null ? scopeCondition : bucketCondition);
        if ("_default".equals(collection) || collection == null) {
            String defaultCollectionCondition = "(bucket_id IS MISSING AND keyspace_id = $bucketName)";
            whereCondition = "(" + whereCondition + " OR " + defaultCollectionCondition + ")";
        }
        return "SELECT idx.* FROM system:indexes AS idx WHERE " + whereCondition + " AND `using` = \"gsi\" ORDER BY is_primary DESC, name ASC";
    }
}

