/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.query;

import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.core.error.AuthenticationFailureException;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DmlFailureException;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.core.error.IndexFailureException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.error.InternalServerFailureException;
import com.couchbase.client.core.error.ParsingFailureException;
import com.couchbase.client.core.error.PlanningFailureException;
import com.couchbase.client.core.error.PreparedStatementFailureException;
import com.couchbase.client.core.error.QuotaLimitedException;
import com.couchbase.client.core.error.RateLimitedException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.context.CancellationErrorContext;
import com.couchbase.client.core.error.context.QueryErrorContext;
import com.couchbase.client.core.io.netty.chunk.BaseChunkResponseParser;
import com.couchbase.client.core.json.stream.JsonStreamParser;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.core.service.ServiceType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class QueryChunkResponseParser
extends BaseChunkResponseParser<QueryChunkHeader, QueryChunkRow, QueryChunkTrailer> {
    private static final List<Integer> PREPARED_ERROR_CODES = Arrays.asList(4040, 4050, 4060, 4070, 4080, 4090);
    private static final List<Integer> RETRYABLE_PREPARED_ERROR_CODES = Arrays.asList(4040, 4050, 4070);
    private String requestId;
    private Optional<byte[]> signature;
    private Optional<String> clientContextId;
    private Optional<String> prepared;
    private String status;
    private byte[] metrics;
    private byte[] warnings;
    private byte[] errors;
    private byte[] profile;
    private final JsonStreamParser.Builder parserBuilder = JsonStreamParser.builder().doOnValue("/requestID", v -> {
        this.requestId = v.readString();
    }).doOnValue("/signature", v -> {
        this.signature = Optional.of(v.readBytes());
    }).doOnValue("/clientContextID", v -> {
        this.clientContextId = Optional.of(v.readString());
    }).doOnValue("/prepared", v -> {
        this.prepared = Optional.of(v.readString());
    }).doOnValue("/results/-", v -> {
        this.markHeaderComplete();
        this.emitRow(new QueryChunkRow(v.readBytes()));
    }).doOnValue("/status", v -> {
        this.markHeaderComplete();
        this.status = v.readString();
    }).doOnValue("/metrics", v -> {
        this.metrics = v.readBytes();
    }).doOnValue("/profile", v -> {
        this.profile = v.readBytes();
    }).doOnValue("/errors", v -> {
        this.errors = v.readBytes();
        this.failRows(QueryChunkResponseParser.errorsToThrowable(this.errors, this.responseHeader(), this.requestContext()));
    }).doOnValue("/warnings", v -> {
        this.warnings = v.readBytes();
    });

    @Override
    protected void doCleanup() {
        this.requestId = null;
        this.signature = Optional.empty();
        this.clientContextId = Optional.empty();
        this.prepared = Optional.empty();
        this.status = null;
        this.metrics = null;
        this.warnings = null;
        this.errors = null;
        this.profile = null;
    }

    @Override
    protected JsonStreamParser.Builder parserBuilder() {
        return this.parserBuilder;
    }

    @Override
    public Optional<QueryChunkHeader> header(boolean lastChunk) {
        return this.isHeaderComplete() ? Optional.of(new QueryChunkHeader(this.requestId, this.clientContextId, this.signature, this.prepared)) : Optional.empty();
    }

    @Override
    public Optional<CouchbaseException> error() {
        return Optional.ofNullable(this.errors).map(bytes -> QueryChunkResponseParser.errorsToThrowable(bytes, this.responseHeader(), this.requestContext()));
    }

    static CouchbaseException errorsToThrowable(byte[] bytes, HttpResponse header, RequestContext ctx) {
        int httpStatus = header != null ? header.status().code() : 0;
        List<ErrorCodeAndMessage> errors = bytes.length == 0 ? Collections.emptyList() : ErrorCodeAndMessage.fromJsonArray(bytes);
        QueryErrorContext errorContext = new QueryErrorContext(ctx, errors, httpStatus);
        if (errors.size() >= 1) {
            int reasonCode;
            ErrorCodeAndMessage codeAndMessage = errors.get(0);
            int code = codeAndMessage.code();
            String message = codeAndMessage.message();
            int n = reasonCode = codeAndMessage.reason() != null ? (Integer)codeAndMessage.reason().getOrDefault("code", 0) : 0;
            if (code == 3000) {
                return new ParsingFailureException(errorContext);
            }
            if (PREPARED_ERROR_CODES.contains(code)) {
                return new PreparedStatementFailureException(errorContext, RETRYABLE_PREPARED_ERROR_CODES.contains(code));
            }
            if (code == 4300 && message.matches("^.*index .*already exist.*")) {
                return new IndexExistsException(errorContext);
            }
            if (code >= 4000 && code < 5000) {
                return new PlanningFailureException(errorContext);
            }
            if (code == 12004 || code == 12016 || code == 5000 && message.matches("^.*index .+ not found.*")) {
                return new IndexNotFoundException(errorContext);
            }
            if (code == 5000 && message.matches("^.*Index .*already exist.*")) {
                return new IndexExistsException(errorContext);
            }
            if (code == 5000 && message.contains("limit for number of indexes that can be created per scope has been reached")) {
                return new QuotaLimitedException(errorContext);
            }
            if (code >= 5000 && code < 6000) {
                return new InternalServerFailureException(errorContext);
            }
            if (code == 12009) {
                if (message.contains("CAS mismatch") || reasonCode == 12033) {
                    return new CasMismatchException(errorContext);
                }
                if (reasonCode == 17014) {
                    return new DocumentNotFoundException(errorContext);
                }
                if (reasonCode == 17012) {
                    return new DocumentExistsException(errorContext);
                }
                return new DmlFailureException(errorContext);
            }
            if (code >= 10000 && code < 11000 || code == 13014) {
                return new AuthenticationFailureException("Could not authenticate query", errorContext, null);
            }
            if (code >= 12000 && code < 13000 || code >= 14000 && code < 15000) {
                return new IndexFailureException(errorContext);
            }
            if (code == 1065) {
                if (message.contains("query_context")) {
                    return FeatureNotAvailableException.scopeLevelQuery(ServiceType.QUERY);
                }
                if (message.contains("preserve_expiry")) {
                    return FeatureNotAvailableException.queryPreserveExpiry();
                }
            } else {
                if (code == 1080) {
                    return new UnambiguousTimeoutException("Query timed out while streaming/receiving rows", new CancellationErrorContext(errorContext));
                }
                if (code == 1191 || code == 1192 || code == 1193 || code == 1194) {
                    return new RateLimitedException(errorContext);
                }
                if (code == 3230) {
                    String feature = null;
                    if (message.contains("Advisor") || message.contains("Advise")) {
                        feature = "Query Index Advisor";
                    } else if (message.contains("Window")) {
                        feature = "Query Window Functions";
                    }
                    return FeatureNotAvailableException.communityEdition(feature);
                }
            }
        }
        return new CouchbaseException("Unknown query error", errorContext);
    }

    @Override
    public void signalComplete() {
        this.completeRows();
        this.completeTrailer(new QueryChunkTrailer(this.status, Optional.ofNullable(this.metrics), Optional.ofNullable(this.warnings), Optional.ofNullable(this.errors), Optional.ofNullable(this.profile)));
    }
}

