/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

@Stability.Volatile
public class CollectionExistsException
extends CouchbaseException {
    private final String collectionName;

    public CollectionExistsException(String collectionName) {
        super("Collection [" + RedactableArgument.redactMeta(collectionName) + "] already exists.");
        this.collectionName = Objects.requireNonNull(collectionName);
    }

    public static CollectionExistsException forCollection(String collectionName) {
        return new CollectionExistsException(collectionName);
    }

    public String collectionName() {
        return this.collectionName;
    }
}

