/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.endpoint.CircuitBreakerConfig;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.node.MemcachedHashingStrategy;
import com.couchbase.client.core.node.StandardMemcachedHashingStrategy;
import com.couchbase.client.core.service.AbstractPooledEndpointServiceConfig;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class IoConfig {
    public static final boolean DEFAULT_MUTATION_TOKENS_ENABLED = true;
    public static final boolean DEFAULT_DNS_SRV_ENABLED = true;
    public static final boolean DEFAULT_TCP_KEEPALIVE_ENABLED = true;
    public static final Duration DEFAULT_TCP_KEEPALIVE_TIME = Duration.ofSeconds(60L);
    public static final Duration DEFAULT_CONFIG_POLL_INTERVAL = Duration.ofMillis(2500L);
    public static final NetworkResolution DEFAULT_NETWORK_RESOLUTION = NetworkResolution.AUTO;
    public static final int DEFAULT_NUM_KV_CONNECTIONS = 1;
    public static final int DEFAULT_MAX_HTTP_CONNECTIONS = 12;
    public static final Duration DEFAULT_IDLE_HTTP_CONNECTION_TIMEOUT = AbstractPooledEndpointServiceConfig.DEFAULT_IDLE_TIME;
    public static final Duration DEFAULT_CONFIG_IDLE_REDIAL_TIMEOUT = Duration.ofMinutes(5L);
    public static final MemcachedHashingStrategy DEFAULT_MEMCACHED_HASHING_STRATEGY = StandardMemcachedHashingStrategy.INSTANCE;
    private final boolean mutationTokensEnabled;
    private final Duration configPollInterval;
    private final CircuitBreakerConfig kvCircuitBreakerConfig;
    private final CircuitBreakerConfig queryCircuitBreakerConfig;
    private final CircuitBreakerConfig viewCircuitBreakerConfig;
    private final CircuitBreakerConfig searchCircuitBreakerConfig;
    private final CircuitBreakerConfig analyticsCircuitBreakerConfig;
    private final CircuitBreakerConfig managerCircuitBreakerConfig;
    private final CircuitBreakerConfig eventingCircuitBreakerConfig;
    private final CircuitBreakerConfig backupCircuitBreakerConfig;
    private final Set<ServiceType> captureTraffic;
    private final NetworkResolution networkResolution;
    private final boolean dnsSrvEnabled;
    private final boolean tcpKeepAlivesEnabled;
    private final Duration tcpKeepAliveTime;
    private final int numKvConnections;
    private final int maxHttpConnections;
    private final Duration idleHttpConnectionTimeout;
    private final Duration configIdleRedialTimeout;
    private final MemcachedHashingStrategy memcachedHashingStrategy;

    private IoConfig(Builder builder) {
        this.mutationTokensEnabled = builder.mutationTokensEnabled;
        this.dnsSrvEnabled = builder.dnsSrvEnabled;
        this.configPollInterval = Optional.ofNullable(builder.configPollInterval).orElse(DEFAULT_CONFIG_POLL_INTERVAL);
        this.kvCircuitBreakerConfig = builder.kvCircuitBreakerConfig.build();
        this.queryCircuitBreakerConfig = builder.queryCircuitBreakerConfig.build();
        this.viewCircuitBreakerConfig = builder.viewCircuitBreakerConfig.build();
        this.searchCircuitBreakerConfig = builder.searchCircuitBreakerConfig.build();
        this.analyticsCircuitBreakerConfig = builder.analyticsCircuitBreakerConfig.build();
        this.managerCircuitBreakerConfig = builder.managerCircuitBreakerConfig.build();
        this.eventingCircuitBreakerConfig = builder.eventingCircuitBreakerConfig.build();
        this.backupCircuitBreakerConfig = builder.backupCircuitBreakerConfig.build();
        this.captureTraffic = Optional.ofNullable(builder.captureTraffic).orElse(Collections.emptySet());
        this.networkResolution = builder.networkResolution;
        this.tcpKeepAlivesEnabled = builder.tcpKeepAlivesEnabled;
        this.tcpKeepAliveTime = builder.tcpKeepAliveTime;
        this.numKvConnections = builder.numKvConnections;
        this.maxHttpConnections = builder.maxHttpConnections;
        this.idleHttpConnectionTimeout = builder.idleHttpConnectionTimeout;
        this.configIdleRedialTimeout = builder.configIdleRedialTimeout;
        this.memcachedHashingStrategy = builder.memcachedHashingStrategy;
    }

    public static IoConfig create() {
        return IoConfig.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder enableMutationTokens(boolean mutationTokensEnabled) {
        return IoConfig.builder().enableMutationTokens(mutationTokensEnabled);
    }

    public static Builder enableDnsSrv(boolean dnsSrvEnabled) {
        return IoConfig.builder().enableDnsSrv(dnsSrvEnabled);
    }

    public static Builder configPollInterval(Duration configPollInterval) {
        return IoConfig.builder().configPollInterval(configPollInterval);
    }

    public static Builder kvCircuitBreakerConfig(CircuitBreakerConfig.Builder kvCircuitBreakerConfig) {
        return IoConfig.builder().kvCircuitBreakerConfig(kvCircuitBreakerConfig);
    }

    public static Builder queryCircuitBreakerConfig(CircuitBreakerConfig.Builder queryCircuitBreakerConfig) {
        return IoConfig.builder().queryCircuitBreakerConfig(queryCircuitBreakerConfig);
    }

    public static Builder viewCircuitBreakerConfig(CircuitBreakerConfig.Builder viewCircuitBreakerConfig) {
        return IoConfig.builder().viewCircuitBreakerConfig(viewCircuitBreakerConfig);
    }

    public static Builder searchCircuitBreakerConfig(CircuitBreakerConfig.Builder searchCircuitBreakerConfig) {
        return IoConfig.builder().searchCircuitBreakerConfig(searchCircuitBreakerConfig);
    }

    public static Builder analyticsCircuitBreakerConfig(CircuitBreakerConfig.Builder analyticsCircuitBreakerConfig) {
        return IoConfig.builder().analyticsCircuitBreakerConfig(analyticsCircuitBreakerConfig);
    }

    public static Builder managerCircuitBreakerConfig(CircuitBreakerConfig.Builder managerCircuitBreakerConfig) {
        return IoConfig.builder().managerCircuitBreakerConfig(managerCircuitBreakerConfig);
    }

    public static Builder eventingCircuitBreakerConfig(CircuitBreakerConfig.Builder eventingCircuitBreakerConfig) {
        return IoConfig.builder().eventingCircuitBreakerConfig(eventingCircuitBreakerConfig);
    }

    @Stability.Volatile
    public static Builder backupCircuitBreakerConfig(CircuitBreakerConfig.Builder backupCircuitBreakerConfig) {
        return IoConfig.builder().backupCircuitBreakerConfig(backupCircuitBreakerConfig);
    }

    public static Builder captureTraffic(ServiceType ... serviceTypes) {
        return IoConfig.builder().captureTraffic(serviceTypes);
    }

    public static Builder networkResolution(NetworkResolution networkResolution) {
        return IoConfig.builder().networkResolution(networkResolution);
    }

    public static Builder enableTcpKeepAlives(boolean tcpKeepAliveEnabled) {
        return IoConfig.builder().enableTcpKeepAlives(tcpKeepAliveEnabled);
    }

    public static Builder tcpKeepAliveTime(Duration tcpKeepAliveTime) {
        return IoConfig.builder().tcpKeepAliveTime(tcpKeepAliveTime);
    }

    public static Builder numKvConnections(int numKvConnections) {
        return IoConfig.builder().numKvConnections(numKvConnections);
    }

    public static Builder maxHttpConnections(int maxHttpConnections) {
        return IoConfig.builder().maxHttpConnections(maxHttpConnections);
    }

    public static Builder idleHttpConnectionTimeout(Duration idleHttpConnectionTimeout) {
        return IoConfig.builder().idleHttpConnectionTimeout(idleHttpConnectionTimeout);
    }

    public static Builder configIdleRedialTimeout(Duration configIdleRedialTimeout) {
        return IoConfig.builder().configIdleRedialTimeout(configIdleRedialTimeout);
    }

    public static Builder memcachedHashingStrategy(MemcachedHashingStrategy memcachedHashingStrategy) {
        return IoConfig.builder().memcachedHashingStrategy(memcachedHashingStrategy);
    }

    public CircuitBreakerConfig kvCircuitBreakerConfig() {
        return this.kvCircuitBreakerConfig;
    }

    public CircuitBreakerConfig queryCircuitBreakerConfig() {
        return this.queryCircuitBreakerConfig;
    }

    public CircuitBreakerConfig viewCircuitBreakerConfig() {
        return this.viewCircuitBreakerConfig;
    }

    public CircuitBreakerConfig searchCircuitBreakerConfig() {
        return this.searchCircuitBreakerConfig;
    }

    public CircuitBreakerConfig analyticsCircuitBreakerConfig() {
        return this.analyticsCircuitBreakerConfig;
    }

    public CircuitBreakerConfig managerCircuitBreakerConfig() {
        return this.managerCircuitBreakerConfig;
    }

    public CircuitBreakerConfig eventingCircuitBreakerConfig() {
        return this.eventingCircuitBreakerConfig;
    }

    @Stability.Volatile
    public CircuitBreakerConfig backupCircuitBreakerConfig() {
        return this.backupCircuitBreakerConfig;
    }

    public boolean mutationTokensEnabled() {
        return this.mutationTokensEnabled;
    }

    public boolean dnsSrvEnabled() {
        return this.dnsSrvEnabled;
    }

    public Duration configPollInterval() {
        return this.configPollInterval;
    }

    public Set<ServiceType> servicesToCapture() {
        return this.captureTraffic;
    }

    public NetworkResolution networkResolution() {
        return this.networkResolution;
    }

    public boolean tcpKeepAlivesEnabled() {
        return this.tcpKeepAlivesEnabled;
    }

    public Duration tcpKeepAliveTime() {
        return this.tcpKeepAliveTime;
    }

    public int numKvConnections() {
        return this.numKvConnections;
    }

    public int maxHttpConnections() {
        return this.maxHttpConnections;
    }

    public Duration idleHttpConnectionTimeout() {
        return this.idleHttpConnectionTimeout;
    }

    public Duration configIdleRedialTimeout() {
        return this.configIdleRedialTimeout;
    }

    public MemcachedHashingStrategy memcachedHashingStrategy() {
        return this.memcachedHashingStrategy;
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("captureTraffic", this.captureTraffic);
        export.put("mutationTokensEnabled", this.mutationTokensEnabled);
        export.put("networkResolution", this.networkResolution.name());
        export.put("dnsSrvEnabled", this.dnsSrvEnabled);
        export.put("tcpKeepAlivesEnabled", this.tcpKeepAlivesEnabled);
        export.put("tcpKeepAliveTimeMs", this.tcpKeepAliveTime.toMillis());
        export.put("configPollIntervalMs", this.configPollInterval.toMillis());
        export.put("kvCircuitBreakerConfig", this.kvCircuitBreakerConfig.enabled() ? this.kvCircuitBreakerConfig.exportAsMap() : "disabled");
        export.put("queryCircuitBreakerConfig", this.queryCircuitBreakerConfig.enabled() ? this.queryCircuitBreakerConfig.exportAsMap() : "disabled");
        export.put("viewCircuitBreakerConfig", this.viewCircuitBreakerConfig.enabled() ? this.viewCircuitBreakerConfig.exportAsMap() : "disabled");
        export.put("searchCircuitBreakerConfig", this.searchCircuitBreakerConfig.enabled() ? this.searchCircuitBreakerConfig.exportAsMap() : "disabled");
        export.put("analyticsCircuitBreakerConfig", this.analyticsCircuitBreakerConfig.enabled() ? this.analyticsCircuitBreakerConfig.exportAsMap() : "disabled");
        export.put("managerCircuitBreakerConfig", this.managerCircuitBreakerConfig.enabled() ? this.managerCircuitBreakerConfig.exportAsMap() : "disabled");
        export.put("eventingCircuitBreakerConfig", this.eventingCircuitBreakerConfig.enabled() ? this.eventingCircuitBreakerConfig.exportAsMap() : "disabled");
        export.put("backupCircuitBreakerConfig", this.backupCircuitBreakerConfig.enabled() ? this.backupCircuitBreakerConfig.exportAsMap() : "disabled");
        export.put("numKvConnections", this.numKvConnections);
        export.put("maxHttpConnections", this.maxHttpConnections);
        export.put("idleHttpConnectionTimeoutMs", this.idleHttpConnectionTimeout.toMillis());
        export.put("configIdleRedialTimeoutMs", this.configIdleRedialTimeout.toMillis());
        export.put("memcachedHashingStrategy", this.memcachedHashingStrategy.getClass().getSimpleName());
        return export;
    }

    public static class Builder {
        private boolean mutationTokensEnabled = true;
        private Duration configPollInterval;
        private CircuitBreakerConfig.Builder kvCircuitBreakerConfig = CircuitBreakerConfig.builder().enabled(false);
        private CircuitBreakerConfig.Builder queryCircuitBreakerConfig = CircuitBreakerConfig.builder().enabled(false);
        private CircuitBreakerConfig.Builder viewCircuitBreakerConfig = CircuitBreakerConfig.builder().enabled(false);
        private CircuitBreakerConfig.Builder searchCircuitBreakerConfig = CircuitBreakerConfig.builder().enabled(false);
        private CircuitBreakerConfig.Builder analyticsCircuitBreakerConfig = CircuitBreakerConfig.builder().enabled(false);
        private CircuitBreakerConfig.Builder managerCircuitBreakerConfig = CircuitBreakerConfig.builder().enabled(false);
        private CircuitBreakerConfig.Builder eventingCircuitBreakerConfig = CircuitBreakerConfig.builder().enabled(false);
        private CircuitBreakerConfig.Builder backupCircuitBreakerConfig = CircuitBreakerConfig.builder().enabled(false);
        private Set<ServiceType> captureTraffic;
        private NetworkResolution networkResolution = DEFAULT_NETWORK_RESOLUTION;
        private boolean dnsSrvEnabled = true;
        private boolean tcpKeepAlivesEnabled = true;
        private Duration tcpKeepAliveTime = DEFAULT_TCP_KEEPALIVE_TIME;
        private int numKvConnections = 1;
        private int maxHttpConnections = 12;
        private Duration idleHttpConnectionTimeout = DEFAULT_IDLE_HTTP_CONNECTION_TIMEOUT;
        private Duration configIdleRedialTimeout = DEFAULT_CONFIG_IDLE_REDIAL_TIMEOUT;
        private MemcachedHashingStrategy memcachedHashingStrategy = DEFAULT_MEMCACHED_HASHING_STRATEGY;

        public IoConfig build() {
            return new IoConfig(this);
        }

        public Builder configPollInterval(Duration configPollInterval) {
            this.configPollInterval = configPollInterval;
            return this;
        }

        public Builder enableMutationTokens(boolean mutationTokensEnabled) {
            this.mutationTokensEnabled = mutationTokensEnabled;
            return this;
        }

        public Builder enableDnsSrv(boolean dnsSrvEnabled) {
            this.dnsSrvEnabled = dnsSrvEnabled;
            return this;
        }

        public Builder enableTcpKeepAlives(boolean tcpKeepAlivesEnabled) {
            this.tcpKeepAlivesEnabled = tcpKeepAlivesEnabled;
            return this;
        }

        public Builder tcpKeepAliveTime(Duration tcpKeepAliveTime) {
            this.tcpKeepAliveTime = tcpKeepAliveTime;
            return this;
        }

        public Builder kvCircuitBreakerConfig(CircuitBreakerConfig.Builder kvCircuitBreakerConfig) {
            this.kvCircuitBreakerConfig = kvCircuitBreakerConfig;
            return this;
        }

        public CircuitBreakerConfig.Builder kvCircuitBreakerConfig() {
            return this.kvCircuitBreakerConfig;
        }

        public Builder queryCircuitBreakerConfig(CircuitBreakerConfig.Builder queryCircuitBreakerConfig) {
            this.queryCircuitBreakerConfig = queryCircuitBreakerConfig;
            return this;
        }

        public CircuitBreakerConfig.Builder queryCircuitBreakerConfig() {
            return this.queryCircuitBreakerConfig;
        }

        public Builder viewCircuitBreakerConfig(CircuitBreakerConfig.Builder viewCircuitBreakerConfig) {
            this.viewCircuitBreakerConfig = viewCircuitBreakerConfig;
            return this;
        }

        public CircuitBreakerConfig.Builder viewCircuitBreakerConfig() {
            return this.viewCircuitBreakerConfig;
        }

        public Builder searchCircuitBreakerConfig(CircuitBreakerConfig.Builder searchCircuitBreakerConfig) {
            this.searchCircuitBreakerConfig = searchCircuitBreakerConfig;
            return this;
        }

        public CircuitBreakerConfig.Builder searchCircuitBreakerConfig() {
            return this.searchCircuitBreakerConfig;
        }

        public Builder analyticsCircuitBreakerConfig(CircuitBreakerConfig.Builder analyticsCircuitBreakerConfig) {
            this.analyticsCircuitBreakerConfig = analyticsCircuitBreakerConfig;
            return this;
        }

        public CircuitBreakerConfig.Builder analyticsCircuitBreakerConfig() {
            return this.analyticsCircuitBreakerConfig;
        }

        public Builder managerCircuitBreakerConfig(CircuitBreakerConfig.Builder managerCircuitBreakerConfig) {
            this.managerCircuitBreakerConfig = managerCircuitBreakerConfig;
            return this;
        }

        public CircuitBreakerConfig.Builder managerCircuitBreakerConfig() {
            return this.managerCircuitBreakerConfig;
        }

        public Builder eventingCircuitBreakerConfig(CircuitBreakerConfig.Builder eventingCircuitBreakerConfig) {
            this.eventingCircuitBreakerConfig = eventingCircuitBreakerConfig;
            return this;
        }

        public CircuitBreakerConfig.Builder eventingCircuitBreakerConfig() {
            return this.eventingCircuitBreakerConfig;
        }

        @Stability.Volatile
        public Builder backupCircuitBreakerConfig(CircuitBreakerConfig.Builder backupCircuitBreakerConfig) {
            this.backupCircuitBreakerConfig = backupCircuitBreakerConfig;
            return this;
        }

        @Stability.Volatile
        public CircuitBreakerConfig.Builder backupCircuitBreakerConfig() {
            return this.backupCircuitBreakerConfig;
        }

        public Builder captureTraffic(ServiceType ... serviceTypes) {
            this.captureTraffic = serviceTypes == null || serviceTypes.length == 0 ? EnumSet.allOf(ServiceType.class) : EnumSet.copyOf(Arrays.asList(serviceTypes));
            return this;
        }

        public Builder networkResolution(NetworkResolution networkResolution) {
            this.networkResolution = networkResolution;
            return this;
        }

        public Builder numKvConnections(int numKvConnections) {
            this.numKvConnections = numKvConnections;
            return this;
        }

        public Builder maxHttpConnections(int maxHttpConnections) {
            this.maxHttpConnections = maxHttpConnections;
            return this;
        }

        public Builder idleHttpConnectionTimeout(Duration idleHttpConnectionTimeout) {
            this.idleHttpConnectionTimeout = idleHttpConnectionTimeout;
            return this;
        }

        public Builder configIdleRedialTimeout(Duration configIdleRedialTimeout) {
            this.configIdleRedialTimeout = configIdleRedialTimeout;
            return this;
        }

        public Builder memcachedHashingStrategy(MemcachedHashingStrategy memcachedHashingStrategy) {
            this.memcachedHashingStrategy = Validators.notNull(memcachedHashingStrategy, "MemcachedHashingStrategy");
            return this;
        }
    }
}

