/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.PipelineInitializer;
import com.couchbase.client.core.io.netty.NonChunkedHttpMessageHandler;
import com.couchbase.client.core.io.netty.eventing.NonChunkedEventingMessageHandler;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;

public class EventingEndpoint
extends BaseEndpoint {
    public EventingEndpoint(ServiceContext ctx, String hostname, int port) {
        super(hostname, port, ctx.environment().ioEnvironment().eventingEventLoopGroup().get(), ctx, ctx.environment().ioConfig().eventingCircuitBreakerConfig(), ServiceType.EVENTING, false);
    }

    @Override
    protected PipelineInitializer pipelineInitializer() {
        return new EventingPipelineInitializer();
    }

    public static class EventingPipelineInitializer
    implements PipelineInitializer {
        @Override
        public void init(BaseEndpoint endpoint, ChannelPipeline pipeline) {
            pipeline.addLast(new HttpClientCodec());
            pipeline.addLast(NonChunkedHttpMessageHandler.IDENTIFIER, (ChannelHandler)new NonChunkedEventingMessageHandler(endpoint));
        }
    }
}

