/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.jctools.queues.atomic;

import com.couchbase.client.core.deps.org.jctools.queues.MessagePassingQueue;
import com.couchbase.client.core.deps.org.jctools.queues.atomic.AtomicQueueUtil;
import com.couchbase.client.core.deps.org.jctools.queues.atomic.BaseSpscLinkedAtomicArrayQueue;
import com.couchbase.client.core.deps.org.jctools.queues.atomic.SpscAtomicArrayQueue;
import com.couchbase.client.core.deps.org.jctools.util.Pow2;
import com.couchbase.client.core.deps.org.jctools.util.RangeUtil;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpscGrowableAtomicArrayQueue<E>
extends BaseSpscLinkedAtomicArrayQueue<E> {
    private final int maxQueueCapacity;
    private long lookAheadStep;

    public SpscGrowableAtomicArrayQueue(int capacity) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(capacity / 8)), capacity);
    }

    public SpscGrowableAtomicArrayQueue(int chunkSize, int capacity) {
        AtomicReferenceArray buffer;
        RangeUtil.checkGreaterThanOrEqual(capacity, 16, "capacity");
        RangeUtil.checkGreaterThanOrEqual(chunkSize, 8, "chunkSize");
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(capacity);
        int chunkCapacity = Pow2.roundToPowerOfTwo(chunkSize);
        RangeUtil.checkLessThan(chunkCapacity, this.maxQueueCapacity, "chunkCapacity");
        long mask = chunkCapacity - 1;
        this.producerBuffer = buffer = AtomicQueueUtil.allocateRefArray(chunkCapacity + 1);
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
        this.adjustLookAheadStep(chunkCapacity);
    }

    @Override
    final boolean offerColdPath(AtomicReferenceArray<E> buffer, long mask, long index, int offset, E v, MessagePassingQueue.Supplier<? extends E> s) {
        int maxCapacity;
        long lookAheadStep = this.lookAheadStep;
        if (lookAheadStep > 0L) {
            int lookAheadElementOffset = AtomicQueueUtil.calcCircularRefElementOffset(index + lookAheadStep, mask);
            if (null == AtomicQueueUtil.lvRefElement(buffer, lookAheadElementOffset)) {
                this.producerBufferLimit = index + lookAheadStep - 1L;
                this.writeToQueue(buffer, v == null ? s.get() : v, index, offset);
                return true;
            }
            int maxCapacity2 = this.maxQueueCapacity;
            if (mask + 1L == (long)maxCapacity2) {
                if (null == AtomicQueueUtil.lvRefElement(buffer, offset)) {
                    this.writeToQueue(buffer, v == null ? s.get() : v, index, offset);
                    return true;
                }
                return false;
            }
            if (null == AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(index + 1L, mask))) {
                this.writeToQueue(buffer, v == null ? s.get() : v, index, offset);
            } else {
                AtomicReferenceArray newBuffer;
                this.producerBuffer = newBuffer = AtomicQueueUtil.allocateRefArray((int)(2L * (mask + 1L) + 1L));
                this.producerMask = AtomicQueueUtil.length(newBuffer) - 2;
                int offsetInNew = AtomicQueueUtil.calcCircularRefElementOffset(index, this.producerMask);
                this.linkOldToNew(index, buffer, offset, newBuffer, offsetInNew, v == null ? s.get() : v);
                int newCapacity = (int)(this.producerMask + 1L);
                if (newCapacity == maxCapacity2) {
                    long currConsumerIndex = this.lvConsumerIndex();
                    this.lookAheadStep = -(index - currConsumerIndex);
                    this.producerBufferLimit = currConsumerIndex + (long)maxCapacity2;
                } else {
                    this.producerBufferLimit = index + this.producerMask - 1L;
                    this.adjustLookAheadStep(newCapacity);
                }
            }
            return true;
        }
        long prevElementsInOtherBuffers = -lookAheadStep;
        long currConsumerIndex = this.lvConsumerIndex();
        int size = (int)(index - currConsumerIndex);
        if (size == (maxCapacity = (int)mask + 1)) {
            return false;
        }
        long firstIndexInCurrentBuffer = this.producerBufferLimit - (long)maxCapacity + prevElementsInOtherBuffers;
        if (currConsumerIndex >= firstIndexInCurrentBuffer) {
            this.adjustLookAheadStep(maxCapacity);
        } else {
            this.lookAheadStep = (int)(currConsumerIndex - firstIndexInCurrentBuffer);
        }
        this.producerBufferLimit = currConsumerIndex + (long)maxCapacity;
        this.writeToQueue(buffer, v == null ? s.get() : v, index, offset);
        return true;
    }

    private void adjustLookAheadStep(int capacity) {
        this.lookAheadStep = Math.min(capacity / 4, SpscAtomicArrayQueue.MAX_LOOK_AHEAD_STEP);
    }

    @Override
    public int capacity() {
        return this.maxQueueCapacity;
    }
}

