/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.loader;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.config.loader.BaseBucketLoader;
import com.couchbase.client.core.error.ConfigException;
import com.couchbase.client.core.error.UnsupportedConfigMechanismException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.CarrierBucketConfigRequest;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.util.Optional;
import reactor.core.publisher.Mono;

public class KeyValueBucketLoader
extends BaseBucketLoader {
    public KeyValueBucketLoader(Core core) {
        super(core, ServiceType.KV);
    }

    @Override
    protected Mono<byte[]> discoverConfig(NodeIdentifier seed, String bucket) {
        CoreContext ctx = this.core().context();
        return Mono.defer(() -> {
            CarrierBucketConfigRequest request = new CarrierBucketConfigRequest(ctx.environment().timeoutConfig().connectTimeout(), ctx, new CollectionIdentifier(bucket, Optional.empty(), Optional.empty()), BestEffortRetryStrategy.INSTANCE, seed);
            this.core().send(request);
            return Reactor.wrap(request, request.response(), true);
        }).map(response -> {
            if (response.status().success()) {
                return response.content();
            }
            if (response.status() == ResponseStatus.UNSUPPORTED) {
                throw new UnsupportedConfigMechanismException();
            }
            throw new ConfigException("Received error status from KeyValueBucketLoader: " + response);
        });
    }
}

