/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.transaction;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.events.transaction.TransactionEvent;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class TransactionLogEvent
extends TransactionEvent {
    static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private final long timestamp;
    private final long threadId;
    private final String threadName;
    private final String transactionId;
    private final String secondaryId;
    private final String fmt;
    private final Object[] values;
    public static final int CHARS_TO_LOG = 5;

    @Stability.Internal
    public TransactionLogEvent(long timestamp, long threadId, String threadName, String transactionId, @Nullable String secondaryId, String fmt, @Nullable Object[] values, Event.Severity level) {
        super(level, DEFAULT_CATEGORY);
        this.timestamp = timestamp;
        this.threadId = threadId;
        this.threadName = Objects.requireNonNull(threadName);
        this.transactionId = Objects.requireNonNull(transactionId);
        this.secondaryId = secondaryId;
        this.fmt = Objects.requireNonNull(fmt);
        this.values = values;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        LocalDateTime localTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.timestamp), ZoneId.systemDefault());
        sb.append(FORMATTER.format(localTime));
        sb.append(' ');
        sb.append(this.threadId);
        sb.append('/');
        sb.append(this.threadName);
        sb.append('/');
        if (this.transactionId.length() > 5) {
            sb.append(this.transactionId.substring(0, 5));
        } else {
            sb.append(this.transactionId);
        }
        if (this.secondaryId != null) {
            sb.append('/');
            if (this.secondaryId.length() > 5) {
                sb.append(this.secondaryId.substring(0, 5));
            } else {
                sb.append(this.secondaryId);
            }
        }
        sb.append(' ');
        if (this.values != null) {
            String value = String.format(this.fmt, this.values);
            sb.append(value);
        } else {
            sb.append(this.fmt);
        }
        return sb.toString();
    }

    @Override
    public String description() {
        return this.toString();
    }
}

