/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.EventSubscription;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

@Stability.Internal
public class SimpleEventBus
implements EventBus {
    private List<Event> publishedEvents = new ArrayList<Event>();
    private final boolean ignoreSystemEvents;
    private final List<Class<? extends Event>> eventsToIgnore;

    public SimpleEventBus(boolean ignoreSystemEvents) {
        this(ignoreSystemEvents, Collections.emptyList());
    }

    public SimpleEventBus(boolean ignoreSystemEvents, List<Class<? extends Event>> othersToIgnore) {
        this.ignoreSystemEvents = ignoreSystemEvents;
        this.eventsToIgnore = Collections.synchronizedList(othersToIgnore);
    }

    @Override
    public synchronized EventBus.PublishResult publish(Event event) {
        boolean inListToIgnore = this.eventsToIgnore.contains(event.getClass());
        if (!(inListToIgnore || this.ignoreSystemEvents && event.category().equals(Event.Category.SYSTEM.path()))) {
            this.publishedEvents.add(event);
        }
        return EventBus.PublishResult.SUCCESS;
    }

    @Override
    public synchronized EventSubscription subscribe(Consumer<Event> consumer) {
        return null;
    }

    @Override
    public synchronized void unsubscribe(EventSubscription subscription) {
    }

    public synchronized List<Event> publishedEvents() {
        return new ArrayList<Event>(this.publishedEvents);
    }

    public synchronized void clear() {
        this.publishedEvents.clear();
    }

    @Override
    public Mono<Void> start() {
        return Mono.empty();
    }

    @Override
    public Mono<Void> stop(Duration timeout) {
        return Mono.empty();
    }
}

