/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc;

import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import java.time.Duration;
import java.time.Instant;

public abstract class AbstractEvent
implements Event {
    private final Event.Severity severity;
    private final String category;
    private final Duration duration;
    private final Context context;
    private final Instant created = Instant.now();
    private final long createdAt = System.nanoTime();

    protected AbstractEvent(Event.Severity severity, Event.Category category, Duration duration, Context context) {
        this(severity, category.path(), duration, context);
    }

    protected AbstractEvent(Event.Severity severity, String category, Duration duration, Context context) {
        this.severity = severity;
        this.category = category;
        this.duration = duration;
        this.context = context;
    }

    @Override
    public Event.Severity severity() {
        return this.severity;
    }

    @Override
    public String category() {
        return this.category;
    }

    @Override
    public Duration duration() {
        return this.duration;
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public long createdAt() {
        return this.createdAt;
    }

    @Override
    public Instant created() {
        return this.created;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{severity=" + (Object)((Object)this.severity) + ", category=" + this.category + ", duration=" + this.duration + ", created=" + this.created + ", description=" + this.description() + ", context=" + this.context.exportAsString(Context.ExportFormat.STRING) + ", cause=" + this.cause() + '}';
    }
}

