/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.views;

import com.dbeaver.db.redis.RedisMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorTrustStoreUI;

public class RedisSSLConfigurator
extends SSLConfiguratorTrustStoreUI {
    private Button skipHostNameValidation;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        this.createSSLConfigHint(composite, true, 1);
        this.createTrustStoreConfigGroup(composite);
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)RedisMessages.connection_page_ssl_legend_settings, (int)1, (int)768, (int)-1);
        this.skipHostNameValidation = UIUtils.createCheckbox((Composite)settingsGroup, (String)RedisMessages.connection_page_ssl_settings_checkbox_skip_hostname_validation, (boolean)false);
    }

    protected boolean useCACertificate() {
        return true;
    }

    protected boolean isKeystoreSupported() {
        return true;
    }

    public void loadSettings(@NotNull DBWHandlerConfiguration configuration) {
        super.loadSettings(configuration);
        this.skipHostNameValidation.setSelection(configuration.getBooleanProperty("@dbeaver-redis.ssl.skipHostValidation"));
    }

    public void saveSettings(@NotNull DBWHandlerConfiguration configuration) {
        super.saveSettings(configuration);
        configuration.setProperty("@dbeaver-redis.ssl.skipHostValidation", (Object)this.skipHostNameValidation.getSelection());
    }
}

