/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.aws;

import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class AuthModelAWSAbstract
extends AuthModelDatabaseNative<AuthModelAWSCredentials> {
    @NotNull
    public AuthModelAWSCredentials createCredentials() {
        return new AuthModelAWSCredentials();
    }

    @NotNull
    public AuthModelAWSCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelAWSCredentials credentials = (AuthModelAWSCredentials)((Object)configuration.getRuntimeAttribute("iam.credentials"));
        if (credentials == null) {
            credentials = (AuthModelAWSCredentials)super.loadCredentials(dataSource, configuration);
        } else {
            credentials = new AuthModelAWSCredentials(credentials);
            super.loadCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
        }
        if (configuration.getAuthProperties() != null) {
            AuthModelAWSAbstract.loadCredentialsFromMap(credentials, configuration.getAuthProperties());
        }
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelAWSCredentials credentials) {
        LinkedHashMap<String, String> authProperties = new LinkedHashMap<String, String>();
        AuthModelAWSAbstract.saveCredentialsToMap(credentials, authProperties);
        for (Map.Entry ap : authProperties.entrySet()) {
            configuration.setAuthProperty((String)ap.getKey(), (String)ap.getValue());
        }
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelAWSCredentials credentials) throws DBException {
        credentials.refreshSession(monitor, dataSource);
    }

    public static void loadCredentialsFromMap(AuthModelAWSCredentials credentials, Map<String, String> authProperties) {
        String secretName;
        String region;
        String profileName = authProperties.get("iam.profile_name");
        if (profileName != null) {
            credentials.setProfileName(profileName);
        }
        if ((region = authProperties.get("iam.region")) != null) {
            credentials.setRegion(region);
        }
        if (authProperties.containsKey("iam.use_default_aws")) {
            credentials.setDefaultAwsCredentials(CommonUtils.getBoolean((String)authProperties.get("iam.use_default_aws")));
        }
        if (authProperties.containsKey("iam.aws_access_key")) {
            credentials.setAwsAccessKey(authProperties.get("iam.aws_access_key"));
            credentials.setAwsSecretKey(authProperties.get("iam.aws_secret_key"));
            credentials.setAwsSessionToken(authProperties.get("iam.aws_session_token"));
        }
        if (authProperties.containsKey("iam.sso_over_cli")) {
            credentials.setSsoOverCli(CommonUtils.getBoolean((String)authProperties.get("iam.sso_over_cli")));
        }
        if (authProperties.containsKey("iam.cross_account_access")) {
            credentials.setCrossAccountAccess(CommonUtils.getBoolean((String)authProperties.get("iam.cross_account_access")));
        }
        if (authProperties.containsKey("iam.account_id")) {
            credentials.setAwsAssumeAccountId(authProperties.get("iam.account_id"));
            credentials.setAwsAssumeRoleName(authProperties.get("iam.role_name"));
            credentials.setAwsExternalId(authProperties.get("iam.external_id"));
        }
        if ((secretName = authProperties.get("iam.aws_secret_name")) != null) {
            credentials.setSecretName(secretName);
        }
    }

    public static void saveCredentialsToMap(@NotNull AuthModelAWSCredentials credentials, Map<String, String> authProperties) {
        if (!CommonUtils.isEmpty((String)credentials.getProfileName())) {
            authProperties.put("iam.profile_name", credentials.getProfileName());
        }
        if (!CommonUtils.isEmpty((String)credentials.getRegion())) {
            authProperties.put("iam.region", credentials.getRegion());
        }
        authProperties.put("iam.use_default_aws", String.valueOf(credentials.isDefaultAwsCredentials()));
        if (!CommonUtils.isEmpty((String)credentials.getAwsAccessKey())) {
            authProperties.put("iam.aws_access_key", credentials.getAwsAccessKey());
        }
        if (!CommonUtils.isEmpty((String)credentials.getAwsSecretKey())) {
            authProperties.put("iam.aws_secret_key", credentials.getAwsSecretKey());
        }
        if (!CommonUtils.isEmpty((String)credentials.getAwsSessionToken())) {
            authProperties.put("iam.aws_session_token", credentials.getAwsSessionToken());
        }
        authProperties.put("iam.sso_over_cli", String.valueOf(credentials.isSsoOverCli()));
        authProperties.put("iam.cross_account_access", String.valueOf(credentials.isCrossAccountAccess()));
        if (!CommonUtils.isEmpty((String)credentials.getAwsAssumeAccountId())) {
            authProperties.put("iam.account_id", credentials.getAwsAssumeAccountId());
        }
        if (!CommonUtils.isEmpty((String)credentials.getAwsAssumeRoleName())) {
            authProperties.put("iam.role_name", credentials.getAwsAssumeRoleName());
        }
        if (!CommonUtils.isEmpty((String)credentials.getSecretName())) {
            authProperties.put("iam.aws_secret_name", credentials.getSecretName());
        }
        if (!CommonUtils.isEmpty((String)credentials.getAwsExternalId())) {
            authProperties.put("iam.external_id", credentials.getAwsExternalId());
        }
    }

    public boolean supportsDatabaseUser() {
        return true;
    }
}

