/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2SourceObject;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2SchemaObject;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TriggerDep;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TriggerDepCache;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TriggerEvent;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TriggerGranularity;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TriggerTime;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TriggerValid;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;
import org.jkiss.utils.CommonUtils;

public class DB2Trigger
extends DB2SchemaObject
implements DBSTrigger,
DB2SourceObject,
DBPRefreshableObject {
    private final DB2TriggerDepCache triggerDepCache = new DB2TriggerDepCache();
    private DB2Table table;
    private String owner;
    private DB2OwnerType ownerType;
    private DB2TriggerTime time;
    private DB2TriggerEvent event;
    private Boolean eventUpdate;
    private Boolean eventDelete;
    private Boolean eventInsert;
    private DB2TriggerGranularity granularity;
    private DB2TriggerValid valid;
    private Timestamp createTime;
    private String qualifier;
    private String funcPath;
    private String text;
    private Timestamp lastRegenTime;
    private String collationSchema;
    private String collationName;
    private String collationSchemaOrderBy;
    private String collationNameOrderBy;
    private Boolean secure;
    private Timestamp alterTime;
    private Integer libId;
    private String precompileOptions;
    private String compileOptions;
    private String remarks;

    public DB2Trigger(DBRProgressMonitor monitor, DB2Schema schema, DB2Table table, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TRIGNAME"), true);
        this.table = table;
        DB2DataSource db2DataSource = (DB2DataSource)table.getDataSource();
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.time = (DB2TriggerTime)CommonUtils.valueOf(DB2TriggerTime.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TRIGTIME"));
        this.event = (DB2TriggerEvent)CommonUtils.valueOf(DB2TriggerEvent.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TRIGEVENT"));
        this.granularity = (DB2TriggerGranularity)CommonUtils.valueOf(DB2TriggerGranularity.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"GRANULARITY"));
        this.valid = (DB2TriggerValid)CommonUtils.valueOf(DB2TriggerValid.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VALID"));
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.qualifier = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"QUALIFIER");
        this.funcPath = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FUNC_PATH");
        this.text = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TEXT");
        this.lastRegenTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_REGEN_TIME");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        if (db2DataSource.isAtLeastV9_5()) {
            this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
            this.collationSchema = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLLATIONSCHEMA");
            this.collationName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATIONNAME");
            this.collationSchemaOrderBy = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATIONSCHEMA_ORDERBY");
            this.collationNameOrderBy = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATIONNAME_ORDERBY");
        }
        if (db2DataSource.isAtLeastV10_1()) {
            this.eventUpdate = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"EVENTUPDATE", (String)DB2YesNo.Y.name());
            this.eventDelete = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"EVENTDELETE", (String)DB2YesNo.Y.name());
            this.eventInsert = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"EVENTINSERT", (String)DB2YesNo.Y.name());
            this.secure = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"SECURE", (String)DB2YesNo.Y.name());
            this.alterTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"ALTER_TIME");
            this.libId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"LIB_ID");
            this.precompileOptions = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PRECOMPILE_OPTIONS");
            this.compileOptions = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMPILE_OPTIONS");
        }
    }

    public DB2Trigger(DB2Schema schema, DB2Table table, String name) {
        super(schema, name, false);
        this.ownerType = DB2OwnerType.U;
        this.time = DB2TriggerTime.B;
        this.event = DB2TriggerEvent.I;
        this.granularity = DB2TriggerGranularity.R;
        this.valid = DB2TriggerValid.X;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid.getState();
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return SQLFormatUtils.formatSQL((DBPDataSource)this.getDataSource(), (String)this.text);
    }

    @Association
    public Collection<DB2TriggerDep> getTriggerDeps(DBRProgressMonitor monitor) throws DBException {
        return this.triggerDepCache.getAllObjects(monitor, this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.triggerDepCache.clearCache();
        return this;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    @Property(viewable=true, order=2, id="Schema")
    public DB2Schema getSchema() {
        return (DB2Schema)super.getParentObject();
    }

    @Property(viewable=true, order=3)
    public DB2Table getTable() {
        return this.table;
    }

    @Property(viewable=true, order=4)
    public DB2TriggerValid getValid() {
        return this.valid;
    }

    @Property(viewable=true, order=5)
    public DB2TriggerEvent getEvent() {
        return this.event;
    }

    @Property(viewable=true, order=6)
    public DB2TriggerTime getTime() {
        return this.time;
    }

    @Property(viewable=true, order=7)
    public Boolean getEventUpdate() {
        return this.eventUpdate;
    }

    @Property(viewable=true, order=8)
    public Boolean getEventDelete() {
        return this.eventDelete;
    }

    @Property(viewable=true, order=9)
    public Boolean getEventInsert() {
        return this.eventInsert;
    }

    @Property(viewable=false, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=true)
    public DB2TriggerGranularity getGranularity() {
        return this.granularity;
    }

    @Property(viewable=false)
    public String getQualifier() {
        return this.qualifier;
    }

    @Property(viewable=false)
    public String getFuncPath() {
        return this.funcPath;
    }

    @Property(viewable=false, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, category="Date & Time")
    public Timestamp getLastRegenTime() {
        return this.lastRegenTime;
    }

    @Property(viewable=false, category="Date & Time")
    public Timestamp getAlterTime() {
        return this.alterTime;
    }

    @Property(viewable=false, category="Collation")
    public String getCollationSchema() {
        return this.collationSchema;
    }

    @Property(viewable=false, category="Collation")
    public String getCollationName() {
        return this.collationName;
    }

    @Property(viewable=false, category="Collation")
    public String getCollationSchemaOrderBy() {
        return this.collationSchemaOrderBy;
    }

    @Property(viewable=false, category="Collation")
    public String getCollationNameOrderBy() {
        return this.collationNameOrderBy;
    }

    @Property(viewable=false)
    public Boolean getSecure() {
        return this.secure;
    }

    @Property(viewable=false)
    public Integer getLibId() {
        return this.libId;
    }

    @Property(viewable=false, category="Compiler")
    public String getPrecompileOptions() {
        return this.precompileOptions;
    }

    @Property(viewable=false, category="Compiler")
    public String getCompileOptions() {
        return this.compileOptions;
    }

    @Override
    @Property(viewable=false, length=PropertyLength.MULTILINE)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }
}

