/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite.remote.ui.views;

import com.dbeaver.db.sqlite.remote.ui.internal.SQLiteRemoteUIActivator;
import com.dbeaver.db.sqlite.remote.ui.internal.SQLiteRemoteUIMessages;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class SQLiteRemoteConnectionPage
extends ConnectionPageAbstract
implements IDialogPageProvider {
    private static final ImageDescriptor LOGO_IMAGE = SQLiteRemoteUIActivator.getImageDescriptor("icons/sqlite_remote_logo.png");
    private Text dbPathText;

    public void createControl(Composite composite) {
        this.setImageDescriptor(LOGO_IMAGE);
        Composite control = new Composite(composite, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(1808));
        Group group = UIUtils.createControlGroup((Composite)control, (String)SQLiteRemoteUIMessages.page_connection_settings_title, (int)2, (int)0, (int)0);
        group.setLayoutData((Object)new GridData(768));
        this.dbPathText = UIUtils.createLabelText((Composite)group, (String)SQLiteRemoteUIMessages.page_connection_settings_remote_path_label, null);
        this.dbPathText.setToolTipText(SQLiteRemoteUIMessages.page_connection_settings_remote_path_tip);
        this.dbPathText.addModifyListener(e -> this.site.updateButtons());
        UIUtils.createInfoLabel((Composite)group, (String)SQLiteRemoteUIMessages.page_connection_settings_remote_ssh_hint, (int)768, (int)2);
        this.createDriverPanel(control);
        this.setControl((Control)control);
    }

    public boolean isComplete() {
        return !CommonUtils.isEmpty((String)this.dbPathText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.dbPathText != null) {
            this.dbPathText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.dbPathText != null) {
            connectionInfo.setDatabaseName(this.dbPathText.getText().trim());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

