CREATE TABLE QM_DBEAVER_PROJECT
(
    PROJECT_ID   INTEGER AUTO_INCREMENT NOT NULL,
    PROJECT_NAME VARCHAR(255) NOT NULL,
    PROJECT_UUID UUID NOT NULL,
    PROJECT_PATH VARCHAR(1024) NOT NULL,
    WORKSPACE_ID INTEGER       NOT NULL,
    UPDATE_TIME  TIMESTAMP     NOT NULL,

    PRIMARY KEY (PROJECT_ID),
    FOREIGN KEY (WORKSPACE_ID) REFERENCES QM_DBEAVER_WORKSPACE (WORKSPACE_ID),
    UNIQUE (WORKSPACE_ID, PROJECT_NAME)
);

ALTER TABLE QM_CONNECTION ADD PROJECT_ID INTEGER AFTER WORKSPACE_ID;
ALTER TABLE QM_CONNECTION ADD FOREIGN KEY (PROJECT_ID) REFERENCES QM_DBEAVER_PROJECT(PROJECT_ID);


