/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DBProxy;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse;

public class DescribeDBProxiesPublisher
implements SdkPublisher<DescribeDbProxiesResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbProxiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBProxiesPublisher(RdsAsyncClient client, DescribeDbProxiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBProxiesPublisher(RdsAsyncClient client, DescribeDbProxiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbProxiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbProxiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBProxy> dbProxies() {
        Function<DescribeDbProxiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbProxies() != null) {
                return response.dbProxies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbProxiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbProxiesResponseFetcher
    implements AsyncPageFetcher<DescribeDbProxiesResponse> {
        private DescribeDbProxiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbProxiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbProxiesResponse> nextPage(DescribeDbProxiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBProxiesPublisher.this.client.describeDBProxies(DescribeDBProxiesPublisher.this.firstRequest);
            }
            return DescribeDBProxiesPublisher.this.client.describeDBProxies((DescribeDbProxiesRequest)((Object)DescribeDBProxiesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

