/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RecurringCharge;
import software.amazon.awssdk.services.rds.model.RecurringChargeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedDBInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedDBInstance> {
    private static final SdkField<String> RESERVED_DB_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedDBInstanceId").getter(ReservedDBInstance.getter(ReservedDBInstance::reservedDBInstanceId)).setter(ReservedDBInstance.setter(Builder::reservedDBInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstanceId").build()}).build();
    private static final SdkField<String> RESERVED_DB_INSTANCES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedDBInstancesOfferingId").getter(ReservedDBInstance.getter(ReservedDBInstance::reservedDBInstancesOfferingId)).setter(ReservedDBInstance.setter(Builder::reservedDBInstancesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOfferingId").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceClass").getter(ReservedDBInstance.getter(ReservedDBInstance::dbInstanceClass)).setter(ReservedDBInstance.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ReservedDBInstance.getter(ReservedDBInstance::startTime)).setter(ReservedDBInstance.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(ReservedDBInstance.getter(ReservedDBInstance::duration)).setter(ReservedDBInstance.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FixedPrice").getter(ReservedDBInstance.getter(ReservedDBInstance::fixedPrice)).setter(ReservedDBInstance.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()}).build();
    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UsagePrice").getter(ReservedDBInstance.getter(ReservedDBInstance::usagePrice)).setter(ReservedDBInstance.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(ReservedDBInstance.getter(ReservedDBInstance::currencyCode)).setter(ReservedDBInstance.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<Integer> DB_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DBInstanceCount").getter(ReservedDBInstance.getter(ReservedDBInstance::dbInstanceCount)).setter(ReservedDBInstance.setter(Builder::dbInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceCount").build()}).build();
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductDescription").getter(ReservedDBInstance.getter(ReservedDBInstance::productDescription)).setter(ReservedDBInstance.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingType").getter(ReservedDBInstance.getter(ReservedDBInstance::offeringType)).setter(ReservedDBInstance.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(ReservedDBInstance.getter(ReservedDBInstance::multiAZ)).setter(ReservedDBInstance.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ReservedDBInstance.getter(ReservedDBInstance::state)).setter(ReservedDBInstance.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecurringCharges").getter(ReservedDBInstance.getter(ReservedDBInstance::recurringCharges)).setter(ReservedDBInstance.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(), ListTrait.builder().memberLocationName("RecurringCharge").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharge").build()}).build()).build()}).build();
    private static final SdkField<String> RESERVED_DB_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedDBInstanceArn").getter(ReservedDBInstance.getter(ReservedDBInstance::reservedDBInstanceArn)).setter(ReservedDBInstance.setter(Builder::reservedDBInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstanceArn").build()}).build();
    private static final SdkField<String> LEASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LeaseId").getter(ReservedDBInstance.getter(ReservedDBInstance::leaseId)).setter(ReservedDBInstance.setter(Builder::leaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_DB_INSTANCE_ID_FIELD, RESERVED_DB_INSTANCES_OFFERING_ID_FIELD, DB_INSTANCE_CLASS_FIELD, START_TIME_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, USAGE_PRICE_FIELD, CURRENCY_CODE_FIELD, DB_INSTANCE_COUNT_FIELD, PRODUCT_DESCRIPTION_FIELD, OFFERING_TYPE_FIELD, MULTI_AZ_FIELD, STATE_FIELD, RECURRING_CHARGES_FIELD, RESERVED_DB_INSTANCE_ARN_FIELD, LEASE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reservedDBInstanceId;
    private final String reservedDBInstancesOfferingId;
    private final String dbInstanceClass;
    private final Instant startTime;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final String currencyCode;
    private final Integer dbInstanceCount;
    private final String productDescription;
    private final String offeringType;
    private final Boolean multiAZ;
    private final String state;
    private final List<RecurringCharge> recurringCharges;
    private final String reservedDBInstanceArn;
    private final String leaseId;

    private ReservedDBInstance(BuilderImpl builder) {
        this.reservedDBInstanceId = builder.reservedDBInstanceId;
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.dbInstanceCount = builder.dbInstanceCount;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.multiAZ = builder.multiAZ;
        this.state = builder.state;
        this.recurringCharges = builder.recurringCharges;
        this.reservedDBInstanceArn = builder.reservedDBInstanceArn;
        this.leaseId = builder.leaseId;
    }

    public final String reservedDBInstanceId() {
        return this.reservedDBInstanceId;
    }

    public final String reservedDBInstancesOfferingId() {
        return this.reservedDBInstancesOfferingId;
    }

    public final String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Double fixedPrice() {
        return this.fixedPrice;
    }

    public final Double usagePrice() {
        return this.usagePrice;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Integer dbInstanceCount() {
        return this.dbInstanceCount;
    }

    public final String productDescription() {
        return this.productDescription;
    }

    public final String offeringType() {
        return this.offeringType;
    }

    public final Boolean multiAZ() {
        return this.multiAZ;
    }

    public final String state() {
        return this.state;
    }

    public final boolean hasRecurringCharges() {
        return this.recurringCharges != null && !(this.recurringCharges instanceof SdkAutoConstructList);
    }

    public final List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public final String reservedDBInstanceArn() {
        return this.reservedDBInstanceArn;
    }

    public final String leaseId() {
        return this.leaseId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecurringCharges() ? this.recurringCharges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.leaseId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedDBInstance)) {
            return false;
        }
        ReservedDBInstance other = (ReservedDBInstance)obj;
        return Objects.equals(this.reservedDBInstanceId(), other.reservedDBInstanceId()) && Objects.equals(this.reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.dbInstanceCount(), other.dbInstanceCount()) && Objects.equals(this.productDescription(), other.productDescription()) && Objects.equals(this.offeringType(), other.offeringType()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.state(), other.state()) && this.hasRecurringCharges() == other.hasRecurringCharges() && Objects.equals(this.recurringCharges(), other.recurringCharges()) && Objects.equals(this.reservedDBInstanceArn(), other.reservedDBInstanceArn()) && Objects.equals(this.leaseId(), other.leaseId());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedDBInstance").add("ReservedDBInstanceId", (Object)this.reservedDBInstanceId()).add("ReservedDBInstancesOfferingId", (Object)this.reservedDBInstancesOfferingId()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("StartTime", (Object)this.startTime()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("UsagePrice", (Object)this.usagePrice()).add("CurrencyCode", (Object)this.currencyCode()).add("DBInstanceCount", (Object)this.dbInstanceCount()).add("ProductDescription", (Object)this.productDescription()).add("OfferingType", (Object)this.offeringType()).add("MultiAZ", (Object)this.multiAZ()).add("State", (Object)this.state()).add("RecurringCharges", this.hasRecurringCharges() ? this.recurringCharges() : null).add("ReservedDBInstanceArn", (Object)this.reservedDBInstanceArn()).add("LeaseId", (Object)this.leaseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedDBInstanceId": {
                return Optional.ofNullable(clazz.cast(this.reservedDBInstanceId()));
            }
            case "ReservedDBInstancesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedDBInstancesOfferingId()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "DBInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceCount()));
            }
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescription()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringType()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
            case "ReservedDBInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.reservedDBInstanceArn()));
            }
            case "LeaseId": {
                return Optional.ofNullable(clazz.cast(this.leaseId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedDBInstance, T> g) {
        return obj -> g.apply((ReservedDBInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedDBInstanceId;
        private String reservedDBInstancesOfferingId;
        private String dbInstanceClass;
        private Instant startTime;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private String currencyCode;
        private Integer dbInstanceCount;
        private String productDescription;
        private String offeringType;
        private Boolean multiAZ;
        private String state;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();
        private String reservedDBInstanceArn;
        private String leaseId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedDBInstance model) {
            this.reservedDBInstanceId(model.reservedDBInstanceId);
            this.reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            this.dbInstanceClass(model.dbInstanceClass);
            this.startTime(model.startTime);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.usagePrice(model.usagePrice);
            this.currencyCode(model.currencyCode);
            this.dbInstanceCount(model.dbInstanceCount);
            this.productDescription(model.productDescription);
            this.offeringType(model.offeringType);
            this.multiAZ(model.multiAZ);
            this.state(model.state);
            this.recurringCharges(model.recurringCharges);
            this.reservedDBInstanceArn(model.reservedDBInstanceArn);
            this.leaseId(model.leaseId);
        }

        public final String getReservedDBInstanceId() {
            return this.reservedDBInstanceId;
        }

        public final void setReservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
        }

        @Override
        @Transient
        public final Builder reservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
            return this;
        }

        public final String getReservedDBInstancesOfferingId() {
            return this.reservedDBInstancesOfferingId;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        @Override
        @Transient
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        @Transient
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        @Transient
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        @Transient
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getDbInstanceCount() {
            return this.dbInstanceCount;
        }

        public final void setDbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
        }

        @Override
        @Transient
        public final Builder dbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
            return this;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        @Transient
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        @Transient
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        @Transient
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        @Transient
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReservedDBInstanceArn() {
            return this.reservedDBInstanceArn;
        }

        public final void setReservedDBInstanceArn(String reservedDBInstanceArn) {
            this.reservedDBInstanceArn = reservedDBInstanceArn;
        }

        @Override
        @Transient
        public final Builder reservedDBInstanceArn(String reservedDBInstanceArn) {
            this.reservedDBInstanceArn = reservedDBInstanceArn;
            return this;
        }

        public final String getLeaseId() {
            return this.leaseId;
        }

        public final void setLeaseId(String leaseId) {
            this.leaseId = leaseId;
        }

        @Override
        @Transient
        public final Builder leaseId(String leaseId) {
            this.leaseId = leaseId;
            return this;
        }

        public ReservedDBInstance build() {
            return new ReservedDBInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedDBInstance> {
        public Builder reservedDBInstanceId(String var1);

        public Builder reservedDBInstancesOfferingId(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder startTime(Instant var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder currencyCode(String var1);

        public Builder dbInstanceCount(Integer var1);

        public Builder productDescription(String var1);

        public Builder offeringType(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder state(String var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);

        public Builder reservedDBInstanceArn(String var1);

        public Builder leaseId(String var1);
    }
}

