/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.parser.common.ParserDispatchResult;
import org.jkiss.dbeaver.parser.common.ParserFsmStep;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaOperation;

class ParserFsmNode {
    private final int id;
    private final List<ParserFsmStep> steps = new ArrayList<ParserFsmStep>();
    private final Map<String, TermGroup> stepsByTermGroup = new HashMap<String, TermGroup>();
    private final List<ParserFsmStep> finalSteps = new ArrayList<ParserFsmStep>();
    private final boolean isEnd;
    private Pattern pattern;

    public ParserFsmNode(int id, boolean isEnd) {
        this.id = id;
        this.isEnd = isEnd;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public int getId() {
        return this.id;
    }

    public List<ParserFsmStep> getTransitions() {
        return Collections.unmodifiableList(this.steps);
    }

    public void connectTo(ParserFsmNode target, String pattern, List<GrammarNfaOperation> operations) {
        this.steps.add(new ParserFsmStep(this, target, pattern, operations));
    }

    public void prepare() {
        HashMap<String, List> stepsByTerm = new HashMap<String, List>();
        for (ParserFsmStep s : this.steps) {
            if (s.getPattern() != null) {
                stepsByTerm.computeIfAbsent(s.getPattern(), p -> new ArrayList()).add(s);
                continue;
            }
            this.finalSteps.add(s);
        }
        ArrayList<String> parts = new ArrayList<String>(stepsByTerm.size());
        for (Map.Entry step : stepsByTerm.entrySet()) {
            String groupName = "g" + this.stepsByTermGroup.size();
            parts.add("(?<" + groupName + ">(" + (String)step.getKey() + "))");
            this.stepsByTermGroup.put(groupName, new TermGroup(groupName, (String)step.getKey(), (List)step.getValue()));
        }
        this.pattern = Pattern.compile("(" + String.join((CharSequence)"|", parts) + ")");
    }

    public void dispatch(String text, int position, ArrayList<ParserDispatchResult> results) {
        Matcher matcher = this.pattern.matcher(text);
        if (matcher.find(position)) {
            for (TermGroup g : this.stepsByTermGroup.values()) {
                int end = matcher.end(g.groupName);
                if (end < 0 || matcher.start(g.groupName) != position) continue;
                for (ParserFsmStep step : g.steps) {
                    results.add(new ParserDispatchResult(end, step));
                }
            }
        }
        for (ParserFsmStep s : this.finalSteps) {
            results.add(new ParserDispatchResult(position, s));
        }
    }

    public String toString() {
        return "#" + this.id;
    }

    private static class TermGroup {
        private final String groupName;
        private final String pattern;
        private final List<ParserFsmStep> steps;

        public TermGroup(String groupName, String pattern, List<ParserFsmStep> steps) {
            this.groupName = groupName;
            this.pattern = pattern;
            this.steps = steps;
        }
    }
}

